/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.ranged;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ScopeModifier
extends Modifier
implements EquipmentChangeModifierHook,
UsingToolModifierHook {
    public static final ResourceLocation SCOPE = TConstruct.getResource("longbow_scope");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.TOOL_USING, ModifierHooks.EQUIPMENT_CHANGE);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView replacement;
        if (context.getLevel().f_46443_ && ((replacement = context.getReplacementTool()) == null || replacement.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(SCOPE));
        }
    }

    @Override
    public void onUsingTick(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        int useTime;
        if (entity.m_9236_().f_46443_ && tool.getModifierLevel(TinkerModifiers.scope.getId()) > 0 && (useTime = useDuration - timeLeft) > 0) {
            float drawTime = tool.getPersistentData().getInt(GeneralInteractionModifierHook.KEY_DRAWTIME);
            if (drawTime <= 0.0f) {
                drawTime = 20.0f;
            }
            float fov = 1.0f - 0.6f * Math.min((float)useTime / drawTime, 1.0f);
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(SCOPE, fov));
        }
    }

    @Deprecated(forRemoval=true)
    public static void scopingUsingTick(IToolStackView tool, LivingEntity entity, int chargeTime) {
    }

    @Deprecated(forRemoval=true)
    public static void stopScoping(LivingEntity entity) {
        if (entity.m_9236_().f_46443_) {
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(SCOPE));
        }
    }
}

