/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.shared.block.entity.TableBlockEntity;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.CastingTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class CastingTankBlockEntity
extends TableBlockEntity
implements ITankBlockEntity.ITankInventoryBlockEntity,
WorldlyContainer {
    public static final int DEFAULT_CAPACITY = 4000;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    private static final Component NAME = TConstruct.makeTranslation("gui", "casting");
    protected final FluidTankAnimated tank;
    private final LazyOptional<IFluidHandler> fluidHolder;
    private boolean lastRedstone;
    private int lastStrength;
    private static final String TAG_REDSTONE = "redstone";

    public static int getCapacity(Block block) {
        return 4000;
    }

    public static int getCapacity(Item item) {
        return 4000;
    }

    public CastingTankBlockEntity(BlockPos pos, BlockState state) {
        TankBlockEntity.ITankBlock tankBlock;
        Block block = state.m_60734_();
        this(pos, state, block instanceof TankBlockEntity.ITankBlock ? (tankBlock = (TankBlockEntity.ITankBlock)block) : (TankBlockEntity.ITankBlock)TinkerSmeltery.searedCastingTank.get());
    }

    public CastingTankBlockEntity(BlockPos pos, BlockState state, TankBlockEntity.ITankBlock block) {
        this((BlockEntityType)TinkerSmeltery.castingTank.get(), pos, state, block);
    }

    protected CastingTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, TankBlockEntity.ITankBlock block) {
        super(type, pos, state, NAME, 2, 1);
        this.lastRedstone = false;
        this.lastStrength = -1;
        this.tank = new FluidTankAnimated(block.getCapacity(), (MantleBlockEntity)this);
        this.fluidHolder = LazyOptional.of(() -> this.tank);
        this.itemHandler = new SidedInvWrapper((WorldlyContainer)this, Direction.DOWN);
    }

    public void interact(Player player, InteractionHand hand, boolean clickedTank) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (clickedTank) {
            if (!FluidTransferHelper.interactWithContainer((Level)this.f_58857_, (BlockPos)this.f_58858_, (IFluidHandler)this.tank, (Player)player, (InteractionHand)hand).didTransfer()) {
                FluidTransferHelper.interactWithFilledBucket((Level)this.f_58857_, (BlockPos)this.f_58858_, (IFluidHandler)this.tank, (Player)player, (InteractionHand)hand, (Direction)((Direction)this.m_58900_().m_61143_((Property)CastingTankBlock.FACING)));
            }
        } else {
            ItemStack input = this.m_8020_(0);
            ItemStack output = this.m_8020_(1);
            ItemStack held = player.m_21120_(hand);
            if (!output.m_41619_()) {
                this.m_6836_(1, ItemStack.f_41583_);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)output, (int)player.m_150109_().f_35977_);
            } else if (!input.m_41619_()) {
                this.m_6836_(0, ItemStack.f_41583_);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)input, (int)player.m_150109_().f_35977_);
            } else if (!held.m_41619_() && this.m_7013_(0, held)) {
                this.m_6836_(0, held.m_41620_(1));
            }
        }
    }

    @Override
    public void m_6836_(int slot, ItemStack newStack) {
        ItemStack oldStack = this.m_8020_(0);
        super.m_6836_(slot, newStack);
        if (slot == 0 && !newStack.m_41619_() && !ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) {
            this.tryToProcessItem();
        }
    }

    private void setInputItem(ItemStack stack) {
        super.m_6836_(0, stack);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        if (pIndex == 0) {
            return this.m_8020_(0).m_41619_() && this.m_8020_(1).m_41619_() && !pStack.m_41619_() && (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(pStack) || pStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent());
        }
        return false;
    }

    public void handleRedstone(boolean hasSignal) {
        if (this.lastRedstone != hasSignal) {
            if (hasSignal && this.f_58857_ != null) {
                this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 2);
            }
            this.lastRedstone = hasSignal;
        }
    }

    public void swap() {
        ItemStack output = this.m_8020_(1);
        this.m_6836_(1, this.m_8020_(0));
        this.m_6836_(0, output);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), Sounds.CASTING_CLICKS.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected void tryToProcessItem() {
        ItemStack input = this.m_8020_(0);
        if (input.m_41619_() || !this.m_8020_(1).m_41619_()) {
            return;
        }
        this.setInputItem(ItemStack.f_41583_);
        IFluidContainerTransfer.TransferResult transferResult = CastingTankBlockEntity.interactWithTankSlotForTransferResult((IFluidHandler)this.tank, input, IFluidContainerTransfer.TransferDirection.AUTO);
        if (transferResult == null) {
            this.setInputItem(input);
        } else {
            SoundEvent sound;
            this.m_6836_(1, transferResult.stack());
            SoundEvent soundEvent = sound = transferResult.didFill() ? FluidTransferHelper.getFillSound((FluidStack)transferResult.fluid()) : FluidTransferHelper.getEmptySound((FluidStack)transferResult.fluid());
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public int[] m_7071_(Direction side) {
        return new int[]{0, 1};
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && !this.isStackInSlot(1);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.fluidHolder.invalidate();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.FLUID_STACK, (Object)this.tank.getFluid()).with(ModelProperties.TANK_CAPACITY, (Object)this.tank.getCapacity()).build();
    }

    @Override
    public void onTankContentsChanged() {
        ITankBlockEntity.ITankInventoryBlockEntity.super.onTankContentsChanged();
        if (this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            this.requestModelDataUpdate();
        }
        this.tryToProcessItem();
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        ITankBlockEntity.ITankInventoryBlockEntity.super.updateFluidTo(fluid);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
        }
    }

    public void setTankTag(ItemStack stack) {
        TankItem.setTank(stack, this.tank);
    }

    public void updateTank(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
            if (this.f_58857_ != null) {
                this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        this.tank.setCapacity(CastingTankBlockEntity.getCapacity(this.m_58900_().m_60734_()));
        this.updateTank(tag.m_128469_("tank"));
        this.lastRedstone = tag.m_128471_(TAG_REDSTONE);
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tags) {
        super.m_183515_(tags);
        tags.m_128379_(TAG_REDSTONE, this.lastRedstone);
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        if (!this.tank.isEmpty()) {
            tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return null;
    }

    @Nullable
    public static IFluidContainerTransfer.TransferResult interactWithTankSlotForTransferResult(IFluidHandler teHandler, ItemStack stack, IFluidContainerTransfer.TransferDirection direction) {
        if (!stack.m_41619_()) {
            IFluidContainerTransfer.TransferResult result;
            FluidStack currentFluid;
            IFluidContainerTransfer transfer;
            if (FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) && (transfer = FluidContainerTransferManager.INSTANCE.getTransfer(stack, currentFluid = teHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE))) != null && (result = transfer.transfer(stack, currentFluid, teHandler, direction)) != null) {
                stack.m_41774_(1);
                return result;
            }
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1);
            LazyOptional itemCapability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (itemCapability.isPresent()) {
                IFluidHandlerItem itemHandler = (IFluidHandlerItem)itemCapability.resolve().orElseThrow();
                FluidStack transferred = FluidStack.EMPTY;
                boolean didFillItem = false;
                if (direction == IFluidContainerTransfer.TransferDirection.REVERSE) {
                    transferred = FluidTransferHelper.tryTransfer((IFluidHandler)teHandler, (IFluidHandler)itemHandler, (int)Integer.MAX_VALUE);
                    boolean bl = didFillItem = !transferred.isEmpty();
                }
                if (direction.canEmpty() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer((IFluidHandler)itemHandler, (IFluidHandler)teHandler, (int)Integer.MAX_VALUE);
                    didFillItem = transferred.isEmpty();
                }
                if (direction != IFluidContainerTransfer.TransferDirection.REVERSE && direction.canFill() && transferred.isEmpty()) {
                    transferred = FluidTransferHelper.tryTransfer((IFluidHandler)teHandler, (IFluidHandler)itemHandler, (int)Integer.MAX_VALUE);
                    boolean bl = didFillItem = !transferred.isEmpty();
                }
                if (!transferred.isEmpty()) {
                    stack.m_41774_(1);
                    return new IFluidContainerTransfer.TransferResult(itemHandler.getContainer(), transferred, didFillItem);
                }
            }
        }
        return null;
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }
}

