/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.technical;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.DeprecatedLoader;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

@Deprecated
public record ArmorStatModule(TinkerDataCapability.TinkerDataKey<Float> key, LevelingValue amount, boolean allowBroken, @Nullable TagKey<Item> heldTag, TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) implements HookProvider,
EquipmentChangeModifierHook,
ModifierModule,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);
    private static final List<ModuleHook<?>> NO_TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE);
    public static final RecordLoadable<ArmorStatModule> LOADER = DeprecatedLoader.modifier(RecordLoadable.create((RecordField)TinkerDataKeys.FLOAT_REGISTRY.requiredField("key", ArmorStatModule::key), (RecordField)LevelingValue.LOADABLE.directField(ArmorStatModule::amount), (RecordField)BooleanLoadable.INSTANCE.defaultField("allow_broken", Boolean.valueOf(false), ArmorStatModule::allowBroken), (RecordField)Loadables.ITEM_TAG.nullableField("held_tag", ArmorStatModule::heldTag), (RecordField)new EnumLoadable(TooltipStyle.class).defaultField("tooltip_style", (Object)TooltipStyle.NONE, ArmorStatModule::tooltipStyle), ModifierCondition.TOOL_FIELD, ArmorStatModule::new), "use 'tconstruct:attribute' with attributes instead of float stats.");

    public RecordLoadable<ArmorStatModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return this.tooltipStyle == TooltipStyle.NONE ? NO_TOOLTIP_HOOKS : TOOLTIP_HOOKS;
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (this.condition.matches(tool, modifier)) {
            ArmorStatModule.addStatIfArmor(tool, context, this.key, this.amount.compute(modifier.getEffectiveLevel()), this.allowBroken, this.heldTag);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        if (this.condition.matches(tool, modifier)) {
            ArmorStatModule.addStatIfArmor(tool, context, this.key, -this.amount.compute(modifier.getEffectiveLevel()), this.allowBroken, this.heldTag);
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.condition.matches(tool, modifier) && (tool.hasTag(TinkerTags.Items.WORN_ARMOR) || this.heldTag != null && tool.hasTag(this.heldTag)) && (!tool.isBroken() || this.allowBroken)) {
            ArmorStatModule.addStatTooltip(modifier, this.key.getId(), this.amount.computeForLevel(modifier.getEffectiveLevel()), this.tooltipStyle, tooltip);
        }
    }

    public static void addStatTooltip(ModifierEntry modifier, ResourceLocation key, float value, TooltipStyle tooltipStyle, List<Component> tooltip) {
        if (value != 0.0f) {
            MutableComponent name = Component.m_237115_((String)Util.makeTranslationKey("armor_stat", key));
            switch (tooltipStyle) {
                case BOOST: {
                    TooltipModifierHook.addFlatBoost(modifier.getModifier(), (Component)name, value, tooltip);
                    break;
                }
                case PERCENT: {
                    TooltipModifierHook.addPercentBoost(modifier.getModifier(), (Component)name, value, tooltip);
                }
            }
        }
    }

    public static void addStat(EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount) {
        context.getTinkerData().ifPresent(data -> {
            float totalLevels = data.get(key, Float.valueOf(0.0f)).floatValue() + amount;
            if (totalLevels <= 0.005f) {
                data.remove(key);
            } else {
                data.put(key, Float.valueOf(totalLevels));
            }
        });
    }

    public static void addStatIfArmor(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount, boolean allowBroken, @Nullable TagKey<Item> heldTag) {
        if (ArmorLevelModule.validSlot(tool, context.getChangedSlot(), heldTag) && (!tool.isBroken() || allowBroken)) {
            ArmorStatModule.addStat(context, key, amount);
        }
    }

    public static float getStat(Entity living, TinkerDataCapability.TinkerDataKey<Float> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Float)data.get(key)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static Builder builder(TinkerDataCapability.TinkerDataKey<Float> key) {
        return new Builder(key);
    }

    public static enum TooltipStyle {
        NONE,
        BOOST,
        PERCENT;

    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<ArmorStatModule> {
        private final TinkerDataCapability.TinkerDataKey<Float> key;
        private boolean allowBroken = false;
        @Nullable
        private TagKey<Item> heldTag;
        private TooltipStyle tooltipStyle = TooltipStyle.NONE;

        public Builder allowBroken() {
            this.allowBroken = true;
            return this;
        }

        @Override
        public ArmorStatModule amount(float flat, float eachLevel) {
            return new ArmorStatModule(this.key, new LevelingValue(flat, eachLevel), this.allowBroken, this.heldTag, this.tooltipStyle, this.condition);
        }

        public Builder allowBroken(boolean allowBroken) {
            this.allowBroken = allowBroken;
            return this;
        }

        public Builder heldTag(@Nullable TagKey<Item> heldTag) {
            this.heldTag = heldTag;
            return this;
        }

        public Builder tooltipStyle(TooltipStyle tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }

        private Builder(TinkerDataCapability.TinkerDataKey<Float> key) {
            this.key = key;
        }
    }
}

