/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.effect;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.shared.TinkerAttributes;

public class AntigravityEffect
extends TinkerEffect {
    private final Int2ObjectMap<LastVelocity> LAST_VELOCITY = new Int2ObjectArrayMap();
    private final IntFunction<LastVelocity> CONSTRUCTOR = i -> new LastVelocity();

    public AntigravityEffect() {
        super(MobEffectCategory.HARMFUL, 16750349, true);
        this.addAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), "5bd6b8c8-8de9-4357-a74e-afb2a8f00c20", -2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingJump);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity living, int amplifier) {
        if (living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) < 0.0) {
            Vec3 velocity;
            Level level = living.m_9236_();
            if (!living.m_9236_().f_46443_ && living.m_20186_() > (double)(level.m_151558_() + 5780)) {
                living.m_6469_(level.m_269111_().m_269341_(), 4.0f);
            }
            LastVelocity lastVelocity = (LastVelocity)this.LAST_VELOCITY.computeIfAbsent(living.m_19879_(), this.CONSTRUCTOR);
            if (living.f_19863_ && !living.f_201939_) {
                if (lastVelocity.twoTicks > (double)0.1f) {
                    velocity = living.m_20184_();
                    living.m_20334_(velocity.f_82479_, lastVelocity.twoTicks, velocity.f_82481_);
                    MobEffectInstance jumpBoost = living.m_21124_(MobEffects.f_19603_);
                    BlockPos above = BlockPos.m_274561_((double)living.m_20185_(), (double)(living.m_20191_().f_82292_ + 0.1), (double)living.m_20189_());
                    BlockState hit = level.m_8055_(above);
                    float height = (float)(lastVelocity.twoTicks * 10.0 - 3.0 - living.m_21133_((Attribute)TinkerAttributes.JUMP_BOOST.get()) - (double)(jumpBoost != null ? jumpBoost.m_19564_() + 1 : 0));
                    if (height > 0.0f) {
                        hit.m_60734_().m_142072_(level, hit, above, (Entity)living, height);
                    }
                    hit.m_60734_().m_5548_((BlockGetter)level, (Entity)living);
                }
                lastVelocity.update(0.0);
            } else {
                lastVelocity.update(living.m_20184_().f_82480_);
            }
            velocity = living.m_20184_();
            double y = velocity.f_82480_;
            if (living.m_6147_()) {
                if (living.f_19862_ || living.f_20899_) {
                    y = -0.2;
                } else if (y > 0.0 && living.m_5791_() && living instanceof Player) {
                    y = 0.0;
                } else if (y > (double)0.15f) {
                    y = 0.15f;
                }
            }
            float friction = 1.0f;
            if (living.f_19863_ && !living.f_201939_ && !living.m_147223_()) {
                BlockPos above = BlockPos.m_274561_((double)living.m_20185_(), (double)(living.m_20191_().f_82292_ + 0.1), (double)living.m_20189_());
                friction = level.m_8055_(above).getFriction((LevelReader)level, above, (Entity)living);
            }
            living.m_20334_(velocity.f_82479_ * (double)friction, y, velocity.f_82481_ * (double)friction);
        }
    }

    public void m_6386_(LivingEntity living, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(living, attributeMap, amplifier);
        this.LAST_VELOCITY.remove(living.m_19879_());
    }

    private void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)this) && entity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) < 0.0) {
            Vec3 movement = entity.m_20184_();
            entity.m_20334_(movement.f_82479_, -movement.f_82480_, movement.f_82481_);
        }
    }

    public boolean antigravityJump(Player player) {
        if (player.f_19863_ && !player.f_201939_ && !player.m_20072_() && player.m_21023_((MobEffect)this) && player.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()) < 0.0 && !player.m_6147_()) {
            player.m_6135_();
            return true;
        }
        return false;
    }

    private static class LastVelocity {
        private double lastTick = 0.0;
        private double twoTicks = 0.0;

        private LastVelocity() {
        }

        void update(double current) {
            this.twoTicks = this.lastTick;
            this.lastTick = current;
        }

        public String toString() {
            return "AntigravityEffect.LastVelocity(lastTick=" + this.lastTick + ", twoTicks=" + this.twoTicks + ")";
        }
    }
}

