/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.IModifierRepairRecipe;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairCraftingRecipe
extends CustomRecipe
implements IModifierRepairRecipe {
    public static final RecordLoadable<ModifierRepairCraftingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)MODIFIER_FIELD, (RecordField)INGREDIENT_FIELD, (RecordField)REPAIR_AMOUNT_FIELD, ModifierRepairCraftingRecipe::new);
    private final ModifierId modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    public ModifierRepairCraftingRecipe(ResourceLocation idIn, ModifierId modifier, Ingredient ingredient, int repairAmount) {
        super(idIn, CraftingBookCategory.EQUIPMENT);
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    @Nullable
    private ToolFound getRelevantInputs(CraftingContainer inv) {
        ItemStack tool = null;
        int itemsFound = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_204117_(TinkerTags.Items.DURABILITY)) {
                if (tool != null) {
                    return null;
                }
                tool = stack;
                continue;
            }
            if (this.ingredient.test(stack)) {
                ++itemsFound;
                continue;
            }
            return null;
        }
        if (tool == null || itemsFound == 0) {
            return null;
        }
        return new ToolFound(tool, itemsFound);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ToolFound inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            return false;
        }
        ToolStack tool = ToolStack.from(inputs.tool);
        return (tool.isBroken() || tool.getDamage() > 0) && tool.getModifierLevel(this.modifier) > 0;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ToolFound inputs = this.getRelevantInputs(inv);
        if (inputs == null) {
            TConstruct.LOG.error("Recipe repair on {} failed to find items after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ToolStack.from(inputs.tool);
        float repairAmount = inputs.itemsFound * this.repairAmount * tool.getModifierLevel(this.modifier);
        for (ModifierEntry entry : tool.getModifierList()) {
            repairAmount = entry.getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairAmount);
            if (!(repairAmount <= 0.0f)) continue;
            return ItemStack.f_41583_;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, (int)repairAmount);
        return tool.copyStack(inputs.tool, 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ToolFound inputs = this.getRelevantInputs(inv);
        int repairPerItem = 0;
        int repairNeeded = 0;
        if (inputs != null) {
            ToolStack tool = ToolStack.from(inputs.tool);
            repairNeeded = tool.getDamage();
            float repairFloat = tool.getModifierLevel(this.modifier) * this.repairAmount;
            if (repairFloat > 0.0f) {
                ModifierEntry entry;
                Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
                while (iterator.hasNext() && !((repairFloat = (entry = iterator.next()).getHook(ModifierHooks.REPAIR_FACTOR).getRepairFactor(tool, entry, repairFloat)) <= 0.0f)) {
                }
                repairPerItem = (int)repairFloat;
            }
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (this.ingredient.test(stack)) {
                if (repairNeeded <= 0) continue;
                repairNeeded -= repairPerItem;
            }
            if (!stack.hasCraftingRemainingItem()) continue;
            list.set(i, (Object)stack.getCraftingRemainingItem());
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.craftingModifierRepair.get();
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }

    private record ToolFound(ItemStack tool, int itemsFound) {
    }
}

