/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.fluid;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ValidateModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.SlotStackModifierHook;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankModule
implements HookProvider,
ToolFluidCapability.FluidModifierHook,
VolatileDataModifierHook,
ValidateModifierHook,
ModifierRemovalHook,
SlotStackModifierHook,
DisplayNameModifierHook {
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ToolFluidCapability.HOOK, ModifierHooks.VOLATILE_DATA, ModifierHooks.VALIDATE, ModifierHooks.REMOVE, ModifierHooks.SLOT_STACK, ModifierHooks.DISPLAY_NAME);
    private final ToolTankHelper helper;

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addVolatileData(IToolContext context, ModifierEntry modifier, ToolDataNBT volatileData) {
        ToolFluidCapability.addTanks(modifier, volatileData, this);
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        FluidStack fluid = this.helper.getFluid(tool);
        int capacity = this.helper.getCapacity(tool);
        if (fluid.isEmpty()) {
            return ToolTankHelper.CAPACITY_STAT.formatValue(capacity);
        }
        return fluid.getDisplayName().m_6881_().m_130946_(": ").m_7220_((Component)ToolTankHelper.CAPACITY_STAT.formatContents(fluid.getAmount(), capacity));
    }

    @Override
    public int getTankCapacity(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.helper.getCapacity(tool);
    }

    @Override
    public FluidStack getFluidInTank(IToolStackView tool, ModifierEntry modifier, int tank) {
        return this.helper.getFluid(tool);
    }

    @Override
    @Nullable
    public Component validate(IToolStackView tool, ModifierEntry modifier) {
        FluidStack fluid = this.helper.getFluid(tool);
        int capacity = this.helper.getCapacity(tool);
        if (fluid.getAmount() > capacity) {
            fluid.setAmount(capacity);
            this.helper.setFluid(tool, fluid);
        }
        return null;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        this.helper.setFluid(tool, FluidStack.EMPTY);
        return null;
    }

    @Override
    public int fill(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty()) {
            FluidStack current = this.helper.getFluid(tool);
            int capacity = this.helper.getCapacity(tool);
            if (current.isEmpty()) {
                if (action.execute()) {
                    this.helper.setFluid(tool, resource);
                }
                return Math.min(resource.getAmount(), capacity);
            }
            if (current.getAmount() < capacity && current.isFluidEqual(resource)) {
                int filled = Math.min(resource.getAmount(), capacity - current.getAmount());
                if (filled > 0 && action.execute()) {
                    current.grow(filled);
                    this.helper.setFluid(tool, current);
                }
                return filled;
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack current;
        modifier.getId();
        if (!resource.isEmpty() && !(current = this.helper.getFluid(tool)).isEmpty() && current.isFluidEqual(resource)) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), resource.getAmount()));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.helper.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.helper.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    public FluidStack drain(IToolStackView tool, ModifierEntry modifier, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack current;
        modifier.getId();
        if (maxDrain > 0 && !(current = this.helper.getFluid(tool)).isEmpty()) {
            FluidStack drained = new FluidStack(current, Math.min(current.getAmount(), maxDrain));
            if (action.execute()) {
                if (drained.getAmount() == current.getAmount()) {
                    this.helper.setFluid(tool, FluidStack.EMPTY);
                } else {
                    current.shrink(drained.getAmount());
                    this.helper.setFluid(tool, current);
                }
            }
            return drained;
        }
        return FluidStack.EMPTY;
    }

    private FluidTank getTank(IToolStackView tool) {
        FluidTank tank = new FluidTank(this.helper.getCapacity(tool));
        tank.setFluid(this.helper.getFluid(tool));
        return tank;
    }

    @Override
    public boolean overrideStackedOnOther(IToolStackView heldTool, ModifierEntry modifier, Slot slot, Player player) {
        ItemStack slotStack = slot.m_7993_();
        if (!slotStack.m_41619_() && TankItem.mayHaveFluid(slotStack)) {
            if (slotStack.m_41613_() == 1) {
                FluidTank tank = this.getTank(heldTool);
                ItemStack result = FluidTransferHelper.interactWithTankSlot((Player)TankItem.clientPlayer(player), (IFluidHandler)tank, (ItemStack)slotStack, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.REVERSE);
                if (!result.m_41619_() || slotStack.m_41619_()) {
                    this.helper.setFluid(heldTool, tank.getFluid());
                    slot.m_5852_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)slotStack, (ItemStack)result));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideOtherStackedOnMe(IToolStackView slotTool, ModifierEntry modifier, ItemStack held, Slot slot, Player player, SlotAccess access) {
        if (!held.m_41619_() && TankItem.mayHaveFluid(held)) {
            FluidTank tank = this.getTank(slotTool);
            int oldCount = held.m_41613_();
            ItemStack result = FluidTransferHelper.interactWithTankSlot((Player)TankItem.clientPlayer(player), (IFluidHandler)tank, (ItemStack)held, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.AUTO);
            if (!result.m_41619_() || held.m_41613_() != oldCount) {
                this.helper.setFluid(slotTool, tank.getFluid());
                TankItem.updateHeldItem(player, held, result);
            }
            return true;
        }
        return false;
    }

    public TankModule(ToolTankHelper helper) {
        this.helper = helper;
    }
}

