/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeCraftingTableRecipe
extends CustomRecipe {
    public static final RecordLoadable<OverslimeCraftingTableRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.defaultField("tools", (Object)Ingredient.m_204132_(TinkerTags.Items.DURABILITY), r -> r.tools), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("restore_amount", r -> r.restoreAmount), OverslimeCraftingTableRecipe::new);
    private final Ingredient tools;
    private final Ingredient ingredient;
    private final int restoreAmount;

    public OverslimeCraftingTableRecipe(ResourceLocation id, Ingredient tools, Ingredient ingredient, int restoreAmount) {
        super(id, CraftingBookCategory.EQUIPMENT);
        this.tools = tools;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
    }

    @Nullable
    private ItemStack findMatch(CraftingContainer inv) {
        boolean foundIngredient = false;
        ItemStack foundTool = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (this.tools.test(stack)) {
                if (foundTool != null) {
                    return null;
                }
                foundTool = stack;
                continue;
            }
            if (this.ingredient.test(stack)) {
                if (foundIngredient) {
                    return null;
                }
                foundIngredient = true;
                continue;
            }
            return null;
        }
        if (!foundIngredient || foundTool == null) {
            return null;
        }
        return foundTool;
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack match = this.findMatch(inv);
        if (match == null) {
            return false;
        }
        ToolStack tool = ToolStack.from(match);
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        return overslime.getShield(tool) < overslime.getShieldCapacity(tool, tool.getModifier(overslime));
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack match = this.findMatch(inv);
        if (match == null) {
            TConstruct.LOG.error("Overslime crafting table recipe {} failed to find tool after matching", (Object)this.m_6423_());
            return ItemStack.f_41583_;
        }
        ToolStack tool = ToolStack.copyFrom(match);
        ModifierId overslime = TinkerModifiers.overslime.getId();
        if (tool.getUpgrades().getLevel(overslime) == 0) {
            tool.addModifier(overslime, 1);
        }
        ((OverslimeModifier)TinkerModifiers.overslime.get()).addOverslime(tool, tool.getModifier(overslime), this.restoreAmount);
        return tool.copyStack(match);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.craftingOverslimeSerializer.get();
    }
}

