/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.recipe.RecipeCacheInvalidator;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;

public class MaterialRecipeCache {
    private static final List<MaterialRecipe> RECIPES = new ArrayList<MaterialRecipe>();
    private static final Map<Item, MaterialRecipe> CACHE = new ConcurrentHashMap<Item, MaterialRecipe>();
    private static final RecipeCacheInvalidator.DuelSidedListener LISTENER = RecipeCacheInvalidator.addDuelSidedListener(() -> {
        RECIPES.clear();
        CACHE.clear();
    });

    public static void registerRecipe(MaterialRecipe recipe) {
        if (recipe.getValue() > 0) {
            LISTENER.checkClear();
            RECIPES.add(recipe);
        }
    }

    public static MaterialRecipe findRecipe(ItemStack stack) {
        if (stack.m_41619_()) {
            return MaterialRecipe.EMPTY;
        }
        return CACHE.computeIfAbsent(stack.m_41720_(), item -> {
            for (MaterialRecipe recipe : RECIPES) {
                if (!recipe.getIngredient().test(stack)) continue;
                return recipe;
            }
            return MaterialRecipe.EMPTY;
        });
    }

    public static Collection<MaterialRecipe> getAllRecipes() {
        return RECIPES;
    }
}

