/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import slimeknights.mantle.data.loadable.common.BlockStateLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ArmorWalkRadiusModule;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record ReplaceBlockWalkerModule(List<BlockReplacement> replacements, LevelingValue radius, IJsonPredicate<IToolContext> tool) implements ArmorWalkRadiusModule<Void>,
ModifierModule
{
    public static final RecordLoadable<ReplaceBlockWalkerModule> LOADER = RecordLoadable.create((RecordField)BlockReplacement.LOADABLE.list().requiredField("replace", ReplaceBlockWalkerModule::replacements), (RecordField)LevelingValue.LOADABLE.requiredField("radius", ReplaceBlockWalkerModule::radius), (RecordField)ToolContextPredicate.LOADER.defaultField("tool", ReplaceBlockWalkerModule::tool), ReplaceBlockWalkerModule::new);

    @Override
    public float getRadius(IToolStackView tool, ModifierEntry modifier) {
        return this.radius.compute(modifier.getLevel() + tool.getModifierLevel(TinkerModifiers.expanded.getId()));
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (this.tool.matches((Object)tool)) {
            ArmorWalkRadiusModule.super.onWalk(tool, modifier, living, prevPos, newPos);
        }
    }

    @Override
    public boolean walkOn(IToolStackView tool, ModifierEntry entry, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable, Void context) {
        if (world.m_46859_(target)) {
            mutable.m_122178_(target.m_123341_(), target.m_123342_() - 1, target.m_123343_());
            int level = entry.getLevel();
            for (BlockReplacement replacement : this.replacements) {
                if (!replacement.level.test(level)) continue;
                BlockState state = replacement.state;
                if (!replacement.target.matches((Object)world.m_8055_((BlockPos)mutable)) || !state.m_60710_((LevelReader)world, (BlockPos)mutable) || !world.m_45752_(state, (BlockPos)mutable, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)living, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)mutable), (Direction)Direction.UP)) continue;
                world.m_46597_((BlockPos)mutable, state);
                world.m_186460_((BlockPos)mutable, state.m_60734_(), Mth.m_216271_((RandomSource)living.m_217043_(), (int)60, (int)120));
                break;
            }
        }
        return tool.isBroken();
    }

    public RecordLoadable<ReplaceBlockWalkerModule> getLoader() {
        return LOADER;
    }

    public static Builder builder() {
        return new Builder();
    }

    private record BlockReplacement(IJsonPredicate<BlockState> target, BlockState state, IntRange level) {
        public static final RecordLoadable<BlockReplacement> LOADABLE = RecordLoadable.create((RecordField)BlockPredicate.LOADER.defaultField("target", BlockReplacement::target), (RecordField)BlockStateLoadable.DIFFERENCE.directField(BlockReplacement::state), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", BlockReplacement::level), BlockReplacement::new);
    }

    public static class Builder
    implements LevelingValue.Builder<ReplaceBlockWalkerModule> {
        private final ImmutableList.Builder<BlockReplacement> replacements = ImmutableList.builder();
        private IJsonPredicate<IToolContext> tool = ToolContextPredicate.ANY;

        private Builder() {
        }

        private Builder replaceLevelRange(IJsonPredicate<BlockState> target, BlockState replacement, IntRange modifierLevel) {
            this.replacements.add((Object)new BlockReplacement(target, replacement, modifierLevel));
            return this;
        }

        public Builder replaceLevelRange(IJsonPredicate<BlockState> target, BlockState replacement, int min, int max) {
            return this.replaceLevelRange(target, replacement, ModifierEntry.VALID_LEVEL.range(min, max));
        }

        public Builder replaceMinLevel(IJsonPredicate<BlockState> target, BlockState replacement, int max) {
            return this.replaceLevelRange(target, replacement, ModifierEntry.VALID_LEVEL.max(max));
        }

        public Builder replaceMaxLevel(IJsonPredicate<BlockState> target, BlockState replacement, int min) {
            return this.replaceLevelRange(target, replacement, ModifierEntry.VALID_LEVEL.min(min));
        }

        public Builder replaceAlways(IJsonPredicate<BlockState> target, BlockState replacement) {
            return this.replaceLevelRange(target, replacement, ModifierEntry.VALID_LEVEL);
        }

        @Override
        public ReplaceBlockWalkerModule amount(float flat, float eachLevel) {
            ImmutableList replacements = this.replacements.build();
            if (replacements.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 replacement");
            }
            return new ReplaceBlockWalkerModule((List<BlockReplacement>)replacements, new LevelingValue(flat, eachLevel), this.tool);
        }

        public Builder tool(IJsonPredicate<IToolContext> tool) {
            this.tool = tool;
            return this;
        }
    }
}

