/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public record LevelingValue(float flat, float eachLevel) {
    public static final RecordLoadable<LevelingValue> LOADABLE = RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("flat", (Object)Float.valueOf(0.0f), LevelingValue::flat), (RecordField)FloatLoadable.ANY.defaultField("each_level", (Object)Float.valueOf(0.0f), LevelingValue::eachLevel), LevelingValue::new);

    public float compute(float level) {
        return this.flat + this.eachLevel * level;
    }

    public float computeForLevel(float level) {
        return level > 0.0f ? this.compute(level) : 0.0f;
    }

    public boolean isFlat() {
        return this.eachLevel == 0.0f;
    }

    @Deprecated(forRemoval=true)
    public JsonObject serialize(JsonObject json) {
        LOADABLE.serialize((Object)this, json);
        return json;
    }

    @Deprecated(forRemoval=true)
    public static LevelingValue deserialize(JsonObject json) {
        return (LevelingValue)LOADABLE.deserialize(json);
    }

    @Deprecated(forRemoval=true)
    public void toNetwork(FriendlyByteBuf buffer) {
        LOADABLE.encode(buffer, (Object)this);
    }

    @Deprecated(forRemoval=true)
    public static LevelingValue fromNetwork(FriendlyByteBuf buffer) {
        return (LevelingValue)LOADABLE.decode(buffer);
    }

    public static LevelingValue flat(float flat) {
        return new LevelingValue(flat, 0.0f);
    }

    public static LevelingValue eachLevel(float eachLevel) {
        return new LevelingValue(0.0f, eachLevel);
    }

    public static interface Builder<M> {
        public M amount(float var1, float var2);

        default public M flat(float flat) {
            return this.amount(flat, 0.0f);
        }

        default public M eachLevel(float eachLevel) {
            return this.amount(0.0f, eachLevel);
        }
    }
}

