/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.controller.MelterBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.SolidFuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MixerAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.SingleAlloyingModule;
import slimeknights.tconstruct.smeltery.menu.AlloyerContainerMenu;

public class AlloyerBlockEntity
extends NameableBlockEntity
implements ITankBlockEntity {
    private static final int TANK_CAPACITY = SearedTankBlock.TankType.INGOT_TANK.getCapacity();
    private static final Component NAME = TConstruct.makeTranslation("gui", "alloyer");
    public static final BlockEntityTicker<AlloyerBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(level, pos, state);
    protected final FluidTankAnimated tank = new FluidTankAnimated(TANK_CAPACITY, (MantleBlockEntity)this);
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    private final MixerAlloyTank alloyTank = new MixerAlloyTank((MantleBlockEntity)this, (IFluidHandler)this.tank);
    private final SingleAlloyingModule alloyingModule = new SingleAlloyingModule((MantleBlockEntity)this, this.alloyTank);
    private final SolidFuelModule fuelModule;
    private int lastStrength = -1;
    private int tick;

    public AlloyerBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.alloyer.get(), pos, state);
    }

    protected AlloyerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, NAME);
        this.fuelModule = new SolidFuelModule((MantleBlockEntity)this, pos.m_7495_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.tankHolder.invalidate();
    }

    private boolean isFormed() {
        BlockState state = this.m_58900_();
        return state.m_61138_((Property)MelterBlock.IN_STRUCTURE) && (Boolean)state.m_61143_((Property)MelterBlock.IN_STRUCTURE) != false;
    }

    private void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.isFormed()) {
            return;
        }
        switch (this.tick) {
            case 0: {
                this.alloyTank.setTemperature(this.fuelModule.findFuel(false));
                if (this.fuelModule.hasFuel() || !this.alloyingModule.canAlloy()) break;
                this.fuelModule.findFuel(true);
                break;
            }
            case 2: {
                boolean hasFuel = this.fuelModule.hasFuel();
                if ((Boolean)state.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    BlockPos down = pos.m_7495_();
                    BlockState downState = level.m_8055_(down);
                    if (downState.m_204336_(TinkerTags.Blocks.FUEL_TANKS) && downState.m_61138_((Property)ControllerBlock.ACTIVE) && (Boolean)downState.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        level.m_46597_(down, (BlockState)downState.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                }
                if (!hasFuel) break;
                this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                this.alloyingModule.doAlloy();
                this.fuelModule.decreaseFuel(1);
            }
        }
        this.tick = (this.tick + 1) % 4;
    }

    public void neighborChanged(Direction side) {
        this.alloyTank.refresh(side, true);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player playerEntity) {
        return new AlloyerContainerMenu(id, inv, this);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.fuelModule.writeToTag(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt.m_128469_("tank"));
        this.fuelModule.readFromTag(nbt);
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    public MixerAlloyTank getAlloyTank() {
        return this.alloyTank;
    }

    public SolidFuelModule getFuelModule() {
        return this.fuelModule;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }
}

