/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.PartSwapCastingRecipe;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class ToolCastingRecipe
extends PartSwapCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    public static final RecordLoadable<ToolCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, (RecordField)ITEM_COST_FIELD, (RecordField)TinkerLoadables.MODIFIABLE_ITEM.requiredField("result", r -> r.result), ToolCastingRecipe::new);
    private final IModifiable result;
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public ToolCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IModifiable result) {
        super(serializer, id, group, cast, itemCost, -1);
        this.result = result;
    }

    @Override
    protected MaterialFluidRecipe getFluidRecipe(ICastingContainer inv) {
        if (inv.getStack().m_41720_() != this.result.m_5456_()) {
            return MaterialCastingLookup.getCastingFluid(inv.getFluid());
        }
        return super.getFluidRecipe(inv);
    }

    @Override
    public boolean matches(ICastingContainer inv, Level level) {
        ItemStack cast = inv.getStack();
        return cast.m_41720_() == this.result.m_5456_() ? super.matches(inv, level) : this.getCast().test(cast);
    }

    @Override
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack((ItemLike)this.result);
    }

    @Override
    public ItemStack assemble(ICastingContainer inv, RegistryAccess access) {
        ItemStack cast = inv.getStack();
        if (cast.m_41720_() == this.result) {
            return super.assemble(inv, access);
        }
        List<MaterialStatsId> stats = ToolMaterialHook.stats(this.result.getToolDefinition());
        MaterialVariant material = this.getFluidRecipe(inv).getOutput();
        MaterialNBT materials = stats.size() > 1 ? new MaterialNBT(List.of(MaterialVariant.of(IMaterialItem.getMaterialFromStack(cast)), material)) : new MaterialNBT(List.of(material));
        return ToolBuildHandler.buildItemFromMaterials(this.result, materials);
    }

    public List<IDisplayableCastingRecipe> getRecipes(RegistryAccess access) {
        if (this.multiRecipes == null) {
            List<MaterialStatsId> requirements = ToolMaterialHook.stats(this.result.getToolDefinition());
            if (requirements.isEmpty()) {
                this.multiRecipes = List.of();
            } else {
                Function<MaterialVariant, MaterialNBT> materials;
                RecipeType<?> type = this.m_6671_();
                List<ItemStack> castItems = Arrays.asList(this.getCast().m_43908_());
                MaterialStatsId requirement = requirements.get(requirements.size() - 1);
                if (requirements.size() > 1) {
                    MaterialVariant firstMaterial = MaterialVariant.of(MaterialRegistry.firstWithStatType(requirements.get(0)));
                    materials = mat -> new MaterialNBT(List.of(firstMaterial, mat));
                } else {
                    materials = mat -> new MaterialNBT(List.of(mat));
                }
                this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                    MaterialVariant output = recipe.getOutput();
                    return !output.isUnknown() && !output.get().isHidden() && requirement.canUseMaterial(output.getId());
                }).map(recipe -> {
                    List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                    int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                    return new DisplayCastingRecipe(type, castItems, fluids, ToolBuildHandler.buildItemFromMaterials(this.result, (MaterialNBT)materials.apply(recipe.getOutput())), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.isConsumed());
                }).collect(Collectors.toList());
            }
        }
        return this.multiRecipes;
    }
}

