/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.tool.ToolFormula;
import slimeknights.tconstruct.library.json.variable.tool.ToolVariable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.behavior.AttributeUniqueField;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record AttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, ToolFormula formula, UUID[] slotUUIDs, TooltipStyle tooltipStyle, ModifierCondition<IToolStackView> condition) implements AttributesModifierHook,
ModifierModule,
EquipmentChangeModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final String[] VARIABLES = new String[]{"level"};
    private static final RecordLoadable<ToolFormula> VARIABLE_LOADER = new VariableFormulaLoadable<ToolVariable, ToolFormula>(ToolVariable.LOADER, VARIABLES, ModifierFormula.FallbackFormula.IDENTITY, (formula, variables, percent) -> new ToolFormula((ModifierFormula)formula, (List<ToolVariable>)variables, VariableFormula.EMPTY_STRINGS));
    private static final List<ModuleHook<?>> ATTRIBUTE_HOOKS = HookProvider.defaultHooks(ModifierHooks.ATTRIBUTES);
    private static final List<ModuleHook<?>> TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);
    private static final List<ModuleHook<?>> NO_TOOLTIP_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE);
    public static final RecordLoadable<AttributeModule> LOADER = RecordLoadable.create(new AttributeUniqueField<AttributeModule>(AttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", AttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", AttributeModule::operation), (RecordField)VARIABLE_LOADER.directField(AttributeModule::formula), (RecordField)TinkerLoadables.EQUIPMENT_SLOT_SET.requiredField("slots", m -> AttributeModule.uuidsToSlots(m.slotUUIDs)), (RecordField)TooltipStyle.LOADABLE.defaultField("tooltip_style", (Object)TooltipStyle.ATTRIBUTE, AttributeModule::tooltipStyle), ModifierCondition.TOOL_FIELD, (unique, attribute, operation, amount, slots, tooltipStyle, condition) -> new AttributeModule((String)unique, (Attribute)attribute, (AttributeModifier.Operation)operation, (ToolFormula)amount, AttributeModule.slotsToUUIDs(unique, slots), (TooltipStyle)((Object)tooltipStyle), (ModifierCondition<IToolStackView>)condition));

    public static UUID getUUID(String name, EquipmentSlot slot) {
        return UUID.nameUUIDFromBytes((name + "." + slot.m_20751_()).getBytes());
    }

    public static UUID[] slotsToUUIDs(String name, Collection<EquipmentSlot> slots) {
        UUID[] slotUUIDs = new UUID[6];
        for (EquipmentSlot slot : slots) {
            slotUUIDs[slot.m_20750_()] = AttributeModule.getUUID(name, slot);
        }
        return slotUUIDs;
    }

    public static Set<EquipmentSlot> uuidsToSlots(UUID[] uuids) {
        EnumSet<EquipmentSlot> set = EnumSet.noneOf(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (uuids[slot.m_20750_()] == null) continue;
            set.add(slot);
        }
        return set;
    }

    @Nullable
    private UUID getUUID(EquipmentSlot slot) {
        return this.slotUUIDs[slot.m_20750_()];
    }

    @Nullable
    private AttributeModifier createModifier(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot) {
        UUID uuid = this.getUUID(slot);
        if (uuid != null) {
            return new AttributeModifier(uuid, this.unique + "." + slot.m_20751_(), (double)this.formula.apply(tool, modifier), this.operation);
        }
        return null;
    }

    @Override
    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        AttributeModifier attributeModifier;
        if (this.condition.matches(tool, modifier) && (attributeModifier = this.createModifier(tool, modifier, slot)) != null) {
            consumer.accept(this.attribute, attributeModifier);
        }
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeModifier attributeModifier;
        AttributeInstance instance;
        if (this.condition.matches(tool, modifier) && (instance = context.getEntity().m_21051_(this.attribute)) != null && (attributeModifier = this.createModifier(tool, modifier, context.getChangedSlot())) != null) {
            instance.m_22120_(attributeModifier.m_22209_());
            instance.m_22118_(attributeModifier);
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance instance;
        UUID uuid;
        if (this.condition.matches(tool, modifier) && (uuid = this.getUUID(context.getChangedSlot())) != null && (instance = context.getEntity().m_21051_(this.attribute)) != null) {
            instance.m_22120_(uuid);
        }
    }

    public static void addTooltip(Modifier modifier, Attribute attribute, AttributeModifier.Operation operation, TooltipStyle tooltipStyle, float amount, @Nullable UUID uuid, @Nullable Player player, List<Component> tooltip) {
        switch (tooltipStyle) {
            case ATTRIBUTE: {
                TooltipUtil.addAttribute(attribute, operation, amount, uuid, player, tooltip);
                break;
            }
            case BOOST: {
                TooltipModifierHook.addFlatBoost(modifier, (Component)Component.m_237115_((String)attribute.m_22087_()), amount, tooltip);
                break;
            }
            case PERCENT: {
                TooltipModifierHook.addPercentBoost(modifier, (Component)Component.m_237115_((String)attribute.m_22087_()), amount, tooltip);
            }
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float value;
        if (this.condition.matches(tool, modifier) && (value = this.formula.apply(tool, modifier)) != 0.0f) {
            AttributeModule.addTooltip(modifier.getModifier(), this.attribute, this.operation, this.tooltipStyle, value, null, player, tooltip);
        }
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        if (this.tooltipStyle == TooltipStyle.ATTRIBUTE) {
            return ATTRIBUTE_HOOKS;
        }
        if (this.tooltipStyle == TooltipStyle.NONE) {
            return NO_TOOLTIP_HOOKS;
        }
        return TOOLTIP_HOOKS;
    }

    public RecordLoadable<AttributeModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(Attribute attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute, operation);
    }

    public static Builder builder(Supplier<Attribute> attribute, AttributeModifier.Operation operation) {
        return new Builder(attribute.get(), operation);
    }

    public static enum TooltipStyle {
        ATTRIBUTE,
        NONE,
        BOOST,
        PERCENT;

        public static final EnumLoadable<TooltipStyle> LOADABLE;

        static {
            LOADABLE = new EnumLoadable(TooltipStyle.class);
        }
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, AttributeModule, ToolVariable> {
        protected final Attribute attribute;
        protected final AttributeModifier.Operation operation;
        protected String unique = "";
        private EquipmentSlot[] slots = EquipmentSlot.values();
        private TooltipStyle tooltipStyle = TooltipStyle.ATTRIBUTE;

        protected Builder(Attribute attribute, AttributeModifier.Operation operation) {
            super(VARIABLES);
            this.attribute = attribute;
            this.operation = operation;
        }

        public Builder slots(EquipmentSlot ... slots) {
            this.slots = slots;
            return this;
        }

        public Builder uniqueFrom(ResourceLocation id) {
            return this.unique(id.m_135827_() + ".modifier." + id.m_135815_());
        }

        @Override
        protected AttributeModule build(ModifierFormula formula) {
            return new AttributeModule(this.unique, this.attribute, this.operation, new ToolFormula(formula, this.variables), AttributeModule.slotsToUUIDs(this.unique, List.of(this.slots)), this.tooltipStyle, this.condition);
        }

        public Builder unique(String unique) {
            this.unique = unique;
            return this;
        }

        public Builder tooltipStyle(TooltipStyle tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }
    }
}

