/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record ScalingFluidEffect<C extends FluidEffectContext>(List<EffectForLevel<C>> effects, RecordLoadable<ScalingFluidEffect<C>> getLoader) implements FluidEffect<C>
{
    public static final RecordLoadable<ScalingFluidEffect<FluidEffectContext.Block>> BLOCK_LOADER = ScalingFluidEffect.createLoader(EffectForLevel.BLOCK_LOADABLE);
    public static final RecordLoadable<ScalingFluidEffect<FluidEffectContext.Entity>> ENTITY_LOADER = ScalingFluidEffect.createLoader(EffectForLevel.ENTITY_LOADABLE);

    @Override
    public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
        float scale = level.value();
        for (int i = this.effects.size() - 1; i >= 0; --i) {
            EffectForLevel<C> effect = this.effects.get(i);
            if (!(scale >= effect.level)) continue;
            return effect.effect.apply(fluid, level.divide(effect.level), (FluidEffectContext)context, action) * effect.level;
        }
        return 0.0f;
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return this.effects.get(this.effects.size() - 1).effect().getDescription(registryAccess);
    }

    @Deprecated(forRemoval=true)
    public static <C extends FluidEffectContext> RecordLoadable<ScalingFluidEffect<C>> createLoader(RecordLoadable<EffectForLevel<C>> effectForScale, Supplier<RecordLoadable<ScalingFluidEffect<C>>> loader) {
        return ScalingFluidEffect.createLoader(effectForScale);
    }

    public static <C extends FluidEffectContext> RecordLoadable<ScalingFluidEffect<C>> createLoader(RecordLoadable<EffectForLevel<C>> effectForScale) {
        return RecordLoadable.withLoader((RecordField)effectForScale.list(1).requiredField("effects", ScalingFluidEffect::effects), ScalingFluidEffect::new).validate((effect, error) -> {
            for (int i = 1; i < effect.effects.size(); ++i) {
                if (!(effect.effects.get((int)(i - 1)).level >= effect.effects.get((int)i).level)) continue;
                throw error.create("Effect scales must be in ascending order, found level " + effect.effects.get((int)(i - 1)).level + " >= " + effect.effects.get((int)i).level);
            }
            return effect;
        });
    }

    public static Builder<FluidEffectContext.Block> blocks() {
        return new Builder<FluidEffectContext.Block>(BLOCK_LOADER);
    }

    @Deprecated(forRemoval=true)
    public static Builder<FluidEffectContext.Entity> entites() {
        return ScalingFluidEffect.entities();
    }

    public static Builder<FluidEffectContext.Entity> entities() {
        return new Builder<FluidEffectContext.Entity>(ENTITY_LOADER);
    }

    public record EffectForLevel<C extends FluidEffectContext>(float level, FluidEffect<? super C> effect) {
        public static final RecordLoadable<EffectForLevel<FluidEffectContext.Block>> BLOCK_LOADABLE = EffectForLevel.createLoader(FluidEffect.BLOCK_EFFECTS);
        public static final RecordLoadable<EffectForLevel<FluidEffectContext.Entity>> ENTITY_LOADABLE = EffectForLevel.createLoader(FluidEffect.ENTITY_EFFECTS);

        public static <C extends FluidEffectContext> RecordLoadable<EffectForLevel<C>> createLoader(GenericLoaderRegistry<FluidEffect<? super C>> loader) {
            return RecordLoadable.create((RecordField)loader.requiredField("effect", EffectForLevel::effect), (RecordField)FloatLoadable.FROM_ZERO.requiredField("level", EffectForLevel::level), (effect1, level1) -> new EffectForLevel(level1.floatValue(), effect1));
        }
    }

    @CanIgnoreReturnValue
    public static class Builder<C extends FluidEffectContext> {
        private final RecordLoadable<ScalingFluidEffect<C>> loader;
        private final List<EffectForLevel<C>> effects = new ArrayList<EffectForLevel<C>>();
        private float lastLevel = -1.0f;

        public Builder<C> effect(float level, FluidEffect<? super C> effect) {
            if (level < 0.0f) {
                throw new IllegalArgumentException("Level must be non-negative");
            }
            if (level < this.lastLevel) {
                throw new IllegalArgumentException("Level must be increasing");
            }
            this.lastLevel = level;
            this.effects.add(new EffectForLevel<C>(level, effect));
            return this;
        }

        public ScalingFluidEffect<C> build() {
            return new ScalingFluidEffect<C>(List.copyOf(this.effects), this.loader);
        }

        public Builder(RecordLoadable<ScalingFluidEffect<C>> loader) {
            this.loader = loader;
        }
    }
}

