/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid;

import java.util.function.BinaryOperator;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.events.teleport.FluidEffectTeleportEvent;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.UnloadableFluidEffect;
import slimeknights.tconstruct.library.utils.TeleportHelper;
import slimeknights.tconstruct.library.utils.Util;

public interface FluidEffect<C extends FluidEffectContext>
extends GenericLoaderRegistry.IHaveLoader,
UnloadableFluidEffect<C> {
    public static final GenericLoaderRegistry<FluidEffect<? super FluidEffectContext.Block>> BLOCK_EFFECTS = new GenericLoaderRegistry("Fluid block effect", false);
    public static final GenericLoaderRegistry<FluidEffect<? super FluidEffectContext.Entity>> ENTITY_EFFECTS = new GenericLoaderRegistry("Fluid entity effect", false);
    public static final FluidEffect<FluidEffectContext> EMPTY = FluidEffect.simple((fluid, scale, context, action) -> 0.0f);
    public static final FluidEffect<FluidEffectContext.Entity> EXTINGUISH_FIRE = FluidEffect.simple((fluid, level, context, action) -> {
        Entity target = context.getTarget();
        if (target.m_6060_() && level.isFull()) {
            if (action.execute()) {
                context.getTarget().m_20095_();
            }
            return 1.0f;
        }
        return 0.0f;
    });
    public static final FluidEffect<FluidEffectContext.Entity> TELEPORT = FluidEffect.simple((fluid, level, context, action) -> {
        LivingEntity target = context.getLivingTarget();
        if (target != null && level.isFull()) {
            if (action.execute()) {
                TeleportHelper.randomNearbyTeleport(target, FluidEffectTeleportEvent.TELEPORT_FACTORY);
            }
            return 1.0f;
        }
        return 0.0f;
    });
    public static final String KEY_SEPARATOR = TConstruct.makeTranslationKey("fluid_effect", "separator");
    public static final BinaryOperator<Component> MERGE_COMPONENT_LIST = (left, right) -> Component.m_237110_((String)KEY_SEPARATOR, (Object[])new Object[]{left, right});

    public static void registerGeneral(ResourceLocation id, RecordLoadable<? extends FluidEffect<FluidEffectContext>> loader) {
        BLOCK_EFFECTS.register(id, loader);
        ENTITY_EFFECTS.register(id, loader);
    }

    public RecordLoadable<? extends FluidEffect<C>> getLoader();

    default public Component getDescription(RegistryAccess registryAccess) {
        return Component.m_237115_((String)FluidEffect.getTranslationKey(this.getLoader()));
    }

    public static <C extends FluidEffectContext> FluidEffect<C> simple(UnloadableFluidEffect<C> effect) {
        return (FluidEffect)SingletonLoader.singleton(loader -> new FluidEffect<C>((RecordLoadable)loader, effect){
            private Component description;
            final /* synthetic */ RecordLoadable val$loader;
            final /* synthetic */ UnloadableFluidEffect val$effect;
            {
                this.val$loader = recordLoadable;
                this.val$effect = unloadableFluidEffect;
            }

            @Override
            public RecordLoadable<? extends FluidEffect<C>> getLoader() {
                return this.val$loader;
            }

            @Override
            public Component getDescription(RegistryAccess registryAccess) {
                if (this.description == null) {
                    this.description = FluidEffect.super.getDescription(registryAccess);
                }
                return this.description;
            }

            @Override
            public float apply(FluidStack fluid, EffectLevel level, C context, IFluidHandler.FluidAction action) {
                return this.val$effect.apply(fluid, level, context, action);
            }
        });
    }

    public static ResourceLocation getLoaderName(RecordLoadable<? extends FluidEffect<?>> loader) {
        ResourceLocation loaderId = ENTITY_EFFECTS.getName(loader);
        if (loaderId != null) {
            return loaderId;
        }
        loaderId = BLOCK_EFFECTS.getName(loader);
        if (loaderId != null) {
            return loaderId;
        }
        Mantle.logger.error("Failed to get default description for unregistered fluid effect loader {}", loader);
        return new ResourceLocation("missingno");
    }

    public static String getTranslationKey(RecordLoadable<? extends FluidEffect<?>> loader) {
        return Util.makeTranslationKey("fluid_effect", FluidEffect.getLoaderName(loader));
    }

    public static Component makeTranslation(RecordLoadable<? extends FluidEffect<?>> loader, Object ... arguments) {
        return Component.m_237110_((String)FluidEffect.getTranslationKey(loader), (Object[])arguments);
    }
}

