/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockBehaviour;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeLookup;

public class TinkerPredicate {
    public static DamageSourcePredicate DIRECT_DAMAGE = DamageSourcePredicate.simple(OnAttackedModifierHook::isDirectDamage);
    public static LivingEntityPredicate AIRBORNE = LivingEntityPredicate.simple(entity -> !entity.m_20096_() && !entity.m_6147_() && !entity.m_20069_() && !entity.m_20159_());
    public static ItemPredicate ARROW = ItemPredicate.simple(item -> item instanceof ArrowItem);
    public static BlockPredicate BLOCKS_MOTION = BlockPredicate.simple(BlockBehaviour.BlockStateBase::m_280555_);
    public static BlockPredicate CAN_MELT_BLOCK = BlockPredicate.simple(state -> MeltingRecipeLookup.canMelt((ItemLike)state.m_60734_()));
    public static ItemPredicate CAN_MELT_ITEM = ItemPredicate.simple(MeltingRecipeLookup::canMelt);

    private TinkerPredicate() {
    }

    public static boolean matches(IJsonPredicate<LivingEntity> predicate, @Nullable LivingEntity entity) {
        if (entity == null) {
            return predicate == LivingEntityPredicate.ANY;
        }
        return predicate.matches((Object)entity);
    }

    public static boolean matchesInTooltip(IJsonPredicate<LivingEntity> predicate, @Nullable LivingEntity entity, TooltipKey tooltipKey) {
        return tooltipKey != TooltipKey.SHIFT || TinkerPredicate.matches(predicate, entity);
    }

    public static boolean matches(IJsonPredicate<DamageSource> predicate, @Nullable DamageSource source) {
        if (source == null) {
            return predicate == DamageSourcePredicate.ANY;
        }
        return predicate.matches((Object)source);
    }
}

