/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class FluidEffectProjectile
extends Projectile {
    private static final EntityDataAccessor<FluidStack> FLUID = SynchedEntityData.m_135353_(FluidEffectProjectile.class, (EntityDataSerializer)TinkerFluids.FLUID_DATA_SERIALIZER);
    private float power = 1.0f;
    private int knockback = 1;

    public FluidEffectProjectile(EntityType<? extends FluidEffectProjectile> type, Level level) {
        super(type, level);
    }

    public FluidEffectProjectile(Level level) {
        this((EntityType<? extends FluidEffectProjectile>)((EntityType)TinkerModifiers.fluidSpitEntity.get()), level);
    }

    public FluidEffectProjectile(Level level, LivingEntity owner, FluidStack fluid, float power) {
        this((EntityType<? extends FluidEffectProjectile>)((EntityType)TinkerModifiers.fluidSpitEntity.get()), level);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
        this.m_5602_((Entity)owner);
        this.setFluid(fluid);
        this.setPower(power);
    }

    public FluidStack getFluid() {
        return (FluidStack)this.f_19804_.m_135370_(FLUID);
    }

    public void setFluid(FluidStack fluid) {
        this.f_19804_.m_135381_(FLUID, (Object)fluid);
    }

    protected Component m_5677_() {
        return this.getFluid().getDisplayName();
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        HitResult.Type hitType = hitResult.m_6662_();
        if (hitType != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        if (!this.m_213877_()) {
            this.m_37283_();
            Vec3 newLocation = this.m_20182_();
            Vec3 velocity = this.m_20184_();
            if (hitType == HitResult.Type.BLOCK) {
                EntityDimensions dimensions = this.m_6095_().m_20680_();
                float factor = 0.01f;
                factor = ((BlockHitResult)hitResult).m_82434_().m_122434_() == Direction.Axis.Y ? (factor += dimensions.f_20378_) : (factor += dimensions.f_20377_ / 2.0f);
                newLocation = hitResult.m_82450_().m_82549_(velocity.m_82541_().m_82490_((double)factor));
            } else {
                newLocation = newLocation.m_82549_(velocity);
            }
            velocity = velocity.m_82490_((double)0.99f);
            if (!this.m_20068_()) {
                velocity = velocity.m_82520_(0.0, -0.06, 0.0);
            }
            this.m_20256_(velocity);
            this.m_146884_(newLocation);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        FluidEffects recipe;
        Vec3 vec3;
        Entity target = result.m_82443_();
        if (this.knockback > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6)).m_82556_() > 0.0) {
            target.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
        FluidStack fluid = this.getFluid();
        Level level = this.m_9236_();
        if (!level.f_46443_ && !fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEntityEffects()) {
            int consumed = recipe.applyToEntity(fluid, this.power, FluidEffectContext.builder(level).user(this.m_19749_()).projectile(this).location(result.m_82450_()).target(target), IFluidHandler.FluidAction.EXECUTE);
            fluid.shrink(consumed);
            if (fluid.isEmpty()) {
                this.m_146870_();
            } else {
                this.setFluid(fluid);
            }
        }
    }

    private static Stream<Direction> orderByNearest(Vec3 delta) {
        record DirectionDistance(Direction direction, double distance) {
        }
        return Arrays.stream(Direction.values()).map(dir -> new DirectionDistance((Direction)dir, -((double)dir.m_122429_() * delta.f_82479_ + (double)dir.m_122430_() * delta.f_82480_ + (double)dir.m_122431_() * delta.f_82481_))).sorted(Comparator.comparingDouble(DirectionDistance::distance)).map(DirectionDistance::direction);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        Level level = this.m_9236_();
        if (!level.f_46443_) {
            FluidEffects recipe;
            FluidStack fluid = this.getFluid();
            if (!fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasBlockEffects()) {
                FluidEffectContext.Block context = FluidEffectContext.builder(level).user(this.m_19749_()).projectile(this).block(hitResult);
                int consumed = recipe.applyToBlock(fluid, this.power, context, IFluidHandler.FluidAction.EXECUTE);
                fluid.shrink(consumed);
                if (!fluid.isEmpty()) {
                    BlockPos hit = hitResult.m_82425_();
                    if (level.m_8055_(hit).m_60795_()) {
                        this.setFluid(fluid);
                        return;
                    }
                    Iterator iterator = FluidEffectProjectile.orderByNearest(this.m_20184_()).iterator();
                    while (iterator.hasNext() && !fluid.isEmpty()) {
                        consumed = recipe.applyToBlock(fluid, this.power, context.withHitResult(Util.offset(hitResult, hit.m_121945_(((Direction)iterator.next()).m_122424_()))), IFluidHandler.FluidAction.EXECUTE);
                        fluid.shrink(consumed);
                    }
                }
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(FLUID, (Object)FluidStack.EMPTY);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        double x = packet.m_131503_();
        double y = packet.m_131504_();
        double z = packet.m_131505_();
        for (int i = 0; i < 7; ++i) {
            double offset = 0.4 + 0.1 * (double)i;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123764_, this.m_20185_(), this.m_20186_(), this.m_20189_(), x * offset, y, z * offset);
        }
        this.m_20334_(x, y, z);
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("power", this.power);
        nbt.m_128405_("knockback", this.knockback);
        FluidStack fluid = this.getFluid();
        if (!fluid.isEmpty()) {
            nbt.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.power = nbt.m_128457_("power");
        this.knockback = nbt.m_128451_("knockback");
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
    }

    public void setPower(float power) {
        this.power = power;
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    public int getKnockback() {
        return this.knockback;
    }
}

