/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.particle.FluidParticleData;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.tools.entity.FluidEffectProjectile;

public class FluidCannonBlockEntity
extends TankBlockEntity {
    private final IFluidCannon block;

    public FluidCannonBlockEntity(BlockPos pos, BlockState state) {
        IFluidCannon tank;
        Block block = state.m_60734_();
        this(pos, state, block instanceof IFluidCannon ? (tank = (IFluidCannon)block) : (IFluidCannon)TinkerSmeltery.searedFluidCannon.get());
    }

    public FluidCannonBlockEntity(BlockPos pos, BlockState state, IFluidCannon block) {
        this((BlockEntityType)TinkerSmeltery.fluidCannon.get(), pos, state, block);
    }

    protected FluidCannonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, IFluidCannon block) {
        super(type, pos, state, block);
        this.block = block;
    }

    public void shoot(BlockState state, ServerLevel level, RandomSource random) {
        FluidEffects recipe;
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            float power = this.block.getPower();
            Direction facing = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            BlockPos target = this.f_58858_.m_121945_(facing);
            BlockState targetState = level.m_8055_(target);
            if (recipe.hasBlockEffects() && !targetState.m_60808_((BlockGetter)level, target).m_83281_()) {
                BlockHitResult hit = Util.createTraceResult(target, facing.m_122424_(), false);
                int consumed = recipe.applyToBlock(fluid, power, FluidEffectContext.builder((Level)level).block(hit), IFluidHandler.FluidAction.EXECUTE);
                if (consumed > 0) {
                    Vec3 location = hit.m_82450_();
                    level.m_8767_((ParticleOptions)new FluidParticleData((ParticleType<FluidParticleData>)((ParticleType)TinkerCommons.fluidParticle.get()), fluid), location.m_7096_(), location.m_7098_(), location.m_7094_(), 10, 0.1, 0.2, 0.1, 0.2);
                    fluid.shrink(consumed);
                    this.tank.setFluid(fluid);
                    this.tank.onContentsChanged();
                    level.m_46796_(2000, this.f_58858_, facing.m_122411_());
                    return;
                }
            }
            if (!targetState.m_60783_((BlockGetter)level, target, facing.m_122424_())) {
                FluidEffectProjectile projectile = new FluidEffectProjectile((Level)level);
                int amount = Math.min(fluid.getAmount(), (int)((float)recipe.getAmount(fluid.getFluid()) * power));
                projectile.setFluid(new FluidStack(fluid, amount));
                projectile.setPower(power);
                projectile.m_6034_((double)this.f_58858_.m_123341_() + 0.5 + 0.7 * (double)facing.m_122429_(), (double)this.f_58858_.m_123342_() + 0.5 + 0.7 * (double)facing.m_122430_(), (double)this.f_58858_.m_123343_() + 0.5 + 0.7 * (double)facing.m_122431_());
                projectile.m_6686_(facing.m_122429_(), (float)facing.m_122430_() + 0.1f, facing.m_122431_(), this.block.getVelocity(), this.block.getInaccuracy());
                level.m_7967_((Entity)projectile);
                level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), SoundEvents.f_12098_, SoundSource.BLOCKS, 1.0f, 1.0f / (random.m_188501_() * 0.4f + 1.2f) + 0.5f);
                fluid.shrink(amount);
                this.tank.setFluid(fluid);
                this.tank.onContentsChanged();
                level.m_46796_(2000, this.f_58858_, facing.m_122411_());
                return;
            }
        }
        level.m_46796_(1001, this.f_58858_, 0);
        level.m_220407_(GameEvent.f_223702_, this.f_58858_, GameEvent.Context.m_223722_((BlockState)state));
    }

    public static interface IFluidCannon
    extends TankBlockEntity.ITankBlock {
        public float getPower();

        public float getVelocity();

        public float getInaccuracy();
    }
}

