/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.entity.DamageFluidEffect;
import slimeknights.tconstruct.library.utils.CustomExplosion;

public record ExplosionFluidEffect(LevelingValue radius, LevelingValue damage, LevelingValue knockback, boolean placeFire, Explosion.BlockInteraction blockInteraction) implements FluidEffect<FluidEffectContext>
{
    public static final RecordLoadable<ExplosionFluidEffect> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("radius", ExplosionFluidEffect::radius), (RecordField)LevelingValue.LOADABLE.requiredField("damage", ExplosionFluidEffect::damage), (RecordField)LevelingValue.LOADABLE.defaultField("knockback", (Object)LevelingValue.flat(1.0f), true, ExplosionFluidEffect::knockback), (RecordField)BooleanLoadable.INSTANCE.defaultField("place_fire", Boolean.valueOf(false), ExplosionFluidEffect::placeFire), (RecordField)new EnumLoadable(Explosion.BlockInteraction.class).requiredField("block_interaction", ExplosionFluidEffect::blockInteraction), ExplosionFluidEffect::new);

    public static Builder radius(float flat, float perLevel) {
        return new Builder(new LevelingValue(flat, perLevel));
    }

    @Override
    public RecordLoadable<? extends FluidEffect<FluidEffectContext>> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext context, IFluidHandler.FluidAction action) {
        boolean isFlat;
        boolean bl = isFlat = this.radius.isFlat() && this.damage.isFlat() && this.knockback.isFlat();
        if (isFlat && !level.isFull()) {
            return 0.0f;
        }
        float value = level.value();
        float radius = this.radius.compute(value);
        if (radius == 0.0f) {
            return 0.0f;
        }
        if (action.execute()) {
            Level world = context.getLevel();
            LivingEntity cause = context.getEntity();
            DamageFluidEffect.DamageTypePair damageType = cause != null ? TinkerDamageTypes.MOB_EXPLOSION : TinkerDamageTypes.EXPLOSION;
            Projectile projectile = context.getProjectile();
            DamageSource damageSource = projectile != null ? TinkerDamageTypes.source(world.m_9598_(), damageType.ranged(), (Entity)projectile, (Entity)cause) : TinkerDamageTypes.source(world.m_9598_(), damageType.melee(), (Entity)cause, (Entity)cause);
            new CustomExplosion(world, context.getLocation(), radius, (Entity)projectile, null, this.damage.compute(value), damageSource, this.knockback.compute(value), null, this.placeFire, this.blockInteraction).handleServer();
        }
        return isFlat ? 1.0f : level.value();
    }

    @Override
    public Component getDescription(RegistryAccess registryAccess) {
        return FluidEffect.makeTranslation(this.getLoader(), Float.valueOf(this.radius.compute(1.0f)));
    }

    @CanIgnoreReturnValue
    public static class Builder {
        private final LevelingValue radius;
        private LevelingValue damage = LevelingValue.flat(0.0f);
        private LevelingValue knockback = LevelingValue.flat(1.0f);
        private boolean placeFire = false;
        private Explosion.BlockInteraction blockInteraction = Explosion.BlockInteraction.DESTROY_WITH_DECAY;

        public Builder ignoreBlocks() {
            return this.blockInteraction(Explosion.BlockInteraction.KEEP);
        }

        public Builder noBlockDecay() {
            return this.blockInteraction(Explosion.BlockInteraction.DESTROY);
        }

        public Builder placeFire() {
            return this.placeFire(true);
        }

        @CheckReturnValue
        public ExplosionFluidEffect build() {
            return new ExplosionFluidEffect(this.radius, this.damage, this.knockback, this.placeFire, this.blockInteraction);
        }

        private Builder(LevelingValue radius) {
            this.radius = radius;
        }

        public Builder damage(LevelingValue damage) {
            this.damage = damage;
            return this;
        }

        public Builder knockback(LevelingValue knockback) {
            this.knockback = knockback;
            return this;
        }

        public Builder placeFire(boolean placeFire) {
            this.placeFire = placeFire;
            return this;
        }

        public Builder blockInteraction(Explosion.BlockInteraction blockInteraction) {
            this.blockInteraction = blockInteraction;
            return this;
        }
    }
}

