/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.entity;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.plugin.jei.MantleJEIConstants;
import slimeknights.mantle.plugin.jei.entity.EntityIngredientRenderer;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.util.IRecipeTooltipReplacement;

public class EntityMeltingRecipeCategory
implements IRecipeCategory<EntityMeltingRecipe> {
    public static final ResourceLocation BACKGROUND_LOC = TConstruct.getResource("textures/gui/jei/melting.png");
    private static final Component TITLE = TConstruct.makeTranslation("jei", "entity_melting.title");
    private static final String KEY_PER_HEARTS = TConstruct.makeTranslationKey("jei", "entity_melting.per_hearts");
    private static final Component TOOLTIP_PER_HEART = Component.m_237115_((String)TConstruct.makeTranslationKey("jei", "entity_melting.per_heart")).m_130940_(ChatFormatting.GRAY);
    private static final Int2ObjectMap<IRecipeSlotTooltipCallback> TOOLTIP_MAP = new Int2ObjectOpenHashMap();
    private final EntityIngredientRenderer entityRenderer = new EntityIngredientRenderer(32);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable arrow;
    private final IDrawable tank;

    public EntityMeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(BACKGROUND_LOC, 0, 41, 150, 62);
        this.icon = helper.createDrawable(BACKGROUND_LOC, 174, 41, 16, 16);
        this.arrow = helper.drawableBuilder(BACKGROUND_LOC, 150, 41, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tank = helper.createDrawable(BACKGROUND_LOC, 150, 74, 16, 16);
    }

    public RecipeType<EntityMeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.ENTITY_MELTING;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void draw(EntityMeltingRecipe recipe, IRecipeSlotsView slot, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 71, 21);
        String damage = Float.toString((float)recipe.getDamage() / 2.0f);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int x = 84 - fontRenderer.m_92895_(damage);
        graphics.m_280056_(fontRenderer, damage, x, 8, Color.RED.getRGB(), false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EntityMeltingRecipe recipe, IFocusGroup focuses) {
        EntityIngredient input = recipe.getIngredient();
        IIngredientAcceptor entities = builder.addSlot(RecipeIngredientRole.INPUT, 19, 11).setCustomRenderer(MantleJEIConstants.ENTITY_TYPE, (IIngredientRenderer)this.entityRenderer).addIngredients(MantleJEIConstants.ENTITY_TYPE, input.getDisplay());
        IIngredientAcceptor eggs = builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(input.getEggs());
        builder.createFocusLink(new IIngredientAcceptor[]{entities, eggs});
        builder.addSlot(RecipeIngredientRole.OUTPUT, 115, 11).setFluidRenderer(180L, false, 16, 32).addTooltipCallback((IRecipeSlotTooltipCallback)TOOLTIP_MAP.computeIfAbsent(recipe.getDamage(), FluidTooltip::new)).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getOutput());
        builder.addSlot(RecipeIngredientRole.CATALYST, 75, 43).setFluidRenderer(1L, false, 16, 16).setOverlay(this.tank, 0, 0).addTooltipCallback((IRecipeSlotTooltipCallback)IRecipeTooltipReplacement.EMPTY).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(1));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private record FluidTooltip(int damage) implements IRecipeTooltipReplacement
    {
        @Override
        public void addMiddleLines(IRecipeSlotView recipeSlotView, List<Component> list) {
            recipeSlotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK).ifPresent(fluid -> FluidTooltipHandler.appendMaterial((FluidStack)fluid, (List)list));
            if (this.damage == 2) {
                list.add(TOOLTIP_PER_HEART);
            } else {
                list.add((Component)Component.m_237110_((String)KEY_PER_HEARTS, (Object[])new Object[]{Float.valueOf((float)this.damage / 2.0f)}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

