/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.recipe.condition.TagFilledCondition;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.fluid.FluidMobEffect;
import slimeknights.tconstruct.library.modifiers.fluid.TimeAction;
import slimeknights.tconstruct.library.modifiers.fluid.block.PlaceBlockFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.DamageFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.entity.FireFluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.general.ConditionalFluidEffect;

public abstract class AbstractFluidEffectProvider
extends GenericDataProvider {
    private final String modId;
    private final Map<ResourceLocation, Builder> entries = new HashMap<ResourceLocation, Builder>();

    public AbstractFluidEffectProvider(PackOutput packOutput, String modId) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/fluid_effects");
        this.modId = modId;
    }

    protected abstract void addFluids();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addFluids();
        return AbstractFluidEffectProvider.allOf(this.entries.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((Builder)entry.getValue()).build())));
    }

    protected Builder addFluid(ResourceLocation id, FluidIngredient fluid) {
        Builder newBuilder = new Builder(fluid);
        Builder original = this.entries.put(id, newBuilder);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate spilling fluid " + id);
        }
        return newBuilder;
    }

    protected Builder addFluid(String name, FluidIngredient fluid) {
        return this.addFluid(new ResourceLocation(this.modId, name), fluid);
    }

    protected Builder addFluid(FluidStack fluid) {
        return this.addFluid(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_(), FluidIngredient.of((FluidStack)fluid));
    }

    protected Builder addFluid(Fluid fluid, int amount) {
        return this.addFluid(BuiltInRegistries.f_257020_.m_7981_((Object)fluid).m_135815_(), (FluidIngredient)FluidIngredient.of((Fluid)fluid, (int)amount));
    }

    protected Builder addFluid(String name, TagKey<Fluid> fluid, int amount) {
        return this.addFluid(name, (FluidIngredient)FluidIngredient.of(fluid, (int)amount));
    }

    protected Builder addFluid(TagKey<Fluid> fluid, int amount) {
        return this.addFluid(fluid.f_203868_().m_135815_(), fluid, amount);
    }

    protected Builder addFluid(FluidObject<?> fluid, int amount) {
        return this.addFluid(fluid.getId().m_135815_(), fluid.ingredient(amount));
    }

    protected Builder addGem(FluidObject<?> fluid) {
        return this.addFluid(fluid, 25);
    }

    protected Builder addMetal(FluidObject<?> fluid) {
        return this.addFluid(fluid, 10);
    }

    protected Builder compatFluid(TagKey<Fluid> fluid, int amount) {
        return this.addFluid(fluid, amount).addCondition((ICondition)new TagFilledCondition(fluid));
    }

    protected Builder compatMetal(FluidObject<?> fluid, String ... extraIngots) {
        Builder builder = this.addMetal(fluid);
        String ourself = fluid.getId().m_135815_().substring("molten_".length());
        if (extraIngots.length == 0) {
            builder.metalCondition(ourself);
        } else {
            builder.metalCondition((String[])Stream.concat(Stream.of(ourself), Stream.of(extraIngots)).toArray(String[]::new));
        }
        return builder;
    }

    protected Builder addClay(FluidObject<?> fluid) {
        return this.addFluid(fluid, 250);
    }

    protected Builder addGlass(FluidObject<?> fluid) {
        return this.addFluid(fluid, 250);
    }

    protected Builder addSlime(FluidObject<?> fluid) {
        return this.addFluid(fluid, 50);
    }

    @Deprecated(forRemoval=true)
    protected Builder burningFluid(TagKey<Fluid> tag, float damage, int time) {
        return this.burningFluid(tag.f_203868_().m_135815_(), tag, 10, damage, time);
    }

    @Deprecated(forRemoval=true)
    protected Builder burningFluid(String name, TagKey<Fluid> tag, int amount, float damage, int time) {
        Builder builder = this.addFluid(name, tag, amount).fireDamage(damage);
        if (time > 0) {
            builder.addEntityEffect(new FireFluidEffect(TimeAction.SET, time)).placeFire();
        }
        return builder;
    }

    @CanIgnoreReturnValue
    protected static class Builder {
        private final List<ICondition> conditions = new ArrayList<ICondition>();
        private final FluidIngredient ingredient;
        private final List<FluidEffect<? super FluidEffectContext.Block>> blockEffects = new ArrayList<FluidEffect<? super FluidEffectContext.Block>>();
        private final List<FluidEffect<? super FluidEffectContext.Entity>> entityEffects = new ArrayList<FluidEffect<? super FluidEffectContext.Entity>>();
        private boolean hidden = false;

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder addCondition(ICondition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder metalCondition(String ... names) {
            ICondition[] conditions = new ICondition[names.length + 1];
            conditions[0] = ConfigEnabledCondition.FORCE_INTEGRATION_MATERIALS;
            for (int i = 0; i < names.length; ++i) {
                conditions[i + 1] = new TagFilledCondition(ItemTags.create((ResourceLocation)Mantle.commonResource((String)("ingots/" + names[i]))));
            }
            return this.addCondition((ICondition)new OrCondition(conditions));
        }

        public Builder addBlockEffect(FluidEffect<? super FluidEffectContext.Block> effect) {
            this.blockEffects.add(effect);
            return this;
        }

        public Builder addEntityEffect(FluidEffect<? super FluidEffectContext.Entity> effect) {
            this.entityEffects.add(effect);
            return this;
        }

        public Builder addEntityEffects(List<? extends FluidEffect<? super FluidEffectContext.Entity>> effects) {
            for (FluidEffect<? super FluidEffectContext.Entity> fluidEffect : effects) {
                this.addEntityEffect(fluidEffect);
            }
            return this;
        }

        public Builder addEffect(FluidMobEffect.Builder builder, TimeAction action) {
            this.addBlockEffect(builder.buildCloud());
            this.addEntityEffects(builder.buildEntity(action));
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder addEffect(TimeAction action, FluidMobEffect.Builder builder) {
            return this.addEffect(builder, action);
        }

        public Builder addEffect(FluidEffect<FluidEffectContext> effect) {
            this.addBlockEffect(effect);
            this.addEntityEffect(effect);
            return this;
        }

        public Builder addBlockEffect(IJsonPredicate<BlockState> predicate, FluidEffect<? super FluidEffectContext.Block> effect) {
            return this.addBlockEffect(new ConditionalFluidEffect.Block(predicate, effect));
        }

        public Builder addEntityEffect(IJsonPredicate<LivingEntity> predicate, FluidEffect<? super FluidEffectContext.Entity> effect) {
            return this.addEntityEffect(new ConditionalFluidEffect.Entity(predicate, effect));
        }

        public Builder placeFire() {
            return this.addBlockEffect(new PlaceBlockFluidEffect(Blocks.f_50083_, SoundEvents.f_11874_));
        }

        public Builder addDamage(float amount, DamageFluidEffect.DamageTypePair type) {
            return this.addEntityEffect(new DamageFluidEffect(amount, type));
        }

        public Builder addDamage(IJsonPredicate<LivingEntity> predicate, float amount, DamageFluidEffect.DamageTypePair type) {
            return this.addEntityEffect(predicate, new DamageFluidEffect(amount, type));
        }

        public Builder impactDamage(float amount) {
            return this.addDamage(amount, TinkerDamageTypes.FLUID_IMPACT);
        }

        public Builder fireDamage(float amount) {
            return this.addDamage((IJsonPredicate<LivingEntity>)LivingEntityPredicate.FIRE_IMMUNE.inverted(), amount, TinkerDamageTypes.FLUID_FIRE);
        }

        public Builder coldDamage(float amount) {
            return this.addDamage((IJsonPredicate<LivingEntity>)LivingEntityPredicate.CAN_FREEZE, amount, TinkerDamageTypes.FLUID_COLD);
        }

        public Builder magicDamage(float amount) {
            return this.addDamage(amount, TinkerDamageTypes.FLUID_MAGIC);
        }

        public Builder spikeDamage(float amount) {
            return this.addDamage(amount, TinkerDamageTypes.FLUID_SPIKE);
        }

        @CheckReturnValue
        private JsonObject build() {
            JsonObject json = new JsonObject();
            if (!this.conditions.isEmpty()) {
                json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])this.conditions.toArray(new ICondition[0])));
            }
            if (this.blockEffects.isEmpty() && this.entityEffects.isEmpty()) {
                throw new IllegalStateException("Must have at least 1 effect");
            }
            FluidEffects.LOADABLE.serialize((Object)new FluidEffects(this.ingredient, this.blockEffects, this.entityEffects, this.hidden), json);
            return json;
        }

        public Builder(FluidIngredient ingredient) {
            this.ingredient = ingredient;
        }
    }
}

