/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;

public class MaterialValueIngredient
extends AbstractIngredient {
    private final MaterialStatsId statType;
    private final float minValue;
    private final float maxValue;
    private ItemStack[] items;

    public static MaterialValueIngredient of(MaterialStatsId statType, float minValue, float maxValue) {
        return new MaterialValueIngredient(statType, minValue, maxValue);
    }

    public static MaterialValueIngredient of(MaterialStatsId statType, float value) {
        return MaterialValueIngredient.of(statType, value, value);
    }

    public boolean test(MaterialRecipe material) {
        float value = (float)material.getValue() / (float)material.getNeeded();
        return this.minValue <= value && value <= this.maxValue && this.statType.canUseMaterial(material.getMaterial().getId());
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        MaterialRecipe recipe = MaterialRecipeCache.findRecipe(stack);
        return recipe != MaterialRecipe.EMPTY && this.test(recipe);
    }

    public ItemStack[] m_43908_() {
        if (this.items == null) {
            this.items = (ItemStack[])MaterialRecipeCache.getAllRecipes().stream().filter(this::test).flatMap(material -> Arrays.stream(material.getIngredient().m_43908_())).toArray(ItemStack[]::new);
        }
        return this.items;
    }

    protected void invalidate() {
        super.invalidate();
        this.items = null;
    }

    public boolean isSimple() {
        return true;
    }

    private boolean contains(MaterialValueIngredient other) {
        return this.minValue <= other.minValue && other.maxValue <= this.maxValue;
    }

    @Nullable
    public MaterialValueIngredient merge(MaterialValueIngredient other) {
        if (!this.statType.equals((Object)other.statType)) {
            return null;
        }
        if (this.contains(other)) {
            return this;
        }
        if (other.contains(this)) {
            return other;
        }
        return new MaterialValueIngredient(this.statType, Math.min(this.minValue, other.minValue), Math.max(this.maxValue, other.maxValue));
    }

    @Nullable
    public MaterialVariantId getMaterial(ItemStack stack) {
        MaterialRecipe recipe = MaterialRecipeCache.findRecipe(stack);
        return recipe != MaterialRecipe.EMPTY && this.test(recipe) ? recipe.getMaterial().getVariant() : null;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Serializer.ID.toString());
        Serializer.STAT_TYPE_FIELD.serialize((Object)this, json);
        if (this.minValue == this.maxValue) {
            json.addProperty("value", (Number)Float.valueOf(this.minValue));
        } else {
            JsonObject value = new JsonObject();
            if (this.minValue > 0.0f) {
                value.addProperty("min", (Number)Float.valueOf(this.minValue));
            }
            if (Float.isFinite(this.maxValue)) {
                value.addProperty("max", (Number)Float.valueOf(this.maxValue));
            }
            json.add("value", (JsonElement)value);
        }
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public MaterialStatsId getStatType() {
        return this.statType;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public MaterialValueIngredient(MaterialStatsId statType, float minValue, float maxValue) {
        this.statType = statType;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public static enum Serializer implements IIngredientSerializer<MaterialValueIngredient>
    {
        INSTANCE;

        public static final ResourceLocation ID;
        private static final LoadableField<MaterialStatsId, MaterialValueIngredient> STAT_TYPE_FIELD;

        public MaterialValueIngredient parse(JsonObject json) {
            float minValue;
            float maxValue;
            MaterialStatsId statType = (MaterialStatsId)((Object)STAT_TYPE_FIELD.get(json));
            JsonElement value = json.get("value");
            if (value.isJsonPrimitive()) {
                minValue = maxValue = value.getAsJsonPrimitive().getAsFloat();
            } else {
                JsonObject object = GsonHelper.m_13918_((JsonElement)value, (String)"value");
                minValue = GsonHelper.m_13820_((JsonObject)object, (String)"min", (float)0.0f);
                maxValue = GsonHelper.m_13820_((JsonObject)object, (String)"max", (float)Float.POSITIVE_INFINITY);
            }
            return new MaterialValueIngredient(statType, minValue, maxValue);
        }

        public MaterialValueIngredient parse(FriendlyByteBuf buffer) {
            return new MaterialValueIngredient((MaterialStatsId)((Object)MaterialStatsId.PARSER.decode(buffer)), buffer.readFloat(), buffer.readFloat());
        }

        public void write(FriendlyByteBuf buffer, MaterialValueIngredient ingredient) {
            STAT_TYPE_FIELD.encode(buffer, (Object)ingredient);
            buffer.writeFloat(ingredient.minValue);
            buffer.writeFloat(ingredient.maxValue);
        }

        static {
            ID = TConstruct.getResource("material_value");
            STAT_TYPE_FIELD = MaterialStatsId.PARSER.requiredField("stat_type", i -> i.statType);
        }
    }
}

