/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.ingredient.NestedIngredient;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialIngredient
extends NestedIngredient {
    private static final MaterialId WILDCARD = IMaterial.UNKNOWN.getIdentifier();
    private final MaterialVariantId material;
    @Nullable
    private final TagKey<IMaterial> tag;
    @Nullable
    private ItemStack[] materialStacks;

    protected MaterialIngredient(Ingredient nested, MaterialVariantId material, @Nullable TagKey<IMaterial> tag) {
        super(nested);
        this.material = material;
        this.tag = tag;
    }

    public static MaterialIngredient of(Ingredient ingredient, MaterialVariantId material) {
        return new MaterialIngredient(ingredient, material, null);
    }

    public static MaterialIngredient of(Ingredient ingredient, TagKey<IMaterial> tag) {
        return new MaterialIngredient(ingredient, WILDCARD, tag);
    }

    public static MaterialIngredient of(ItemLike item, MaterialVariantId material) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), material);
    }

    public static MaterialIngredient of(ItemLike item, TagKey<IMaterial> tag) {
        return MaterialIngredient.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), tag);
    }

    public static MaterialIngredient of(ItemLike item) {
        return MaterialIngredient.of(item, (MaterialVariantId)WILDCARD);
    }

    public static MaterialIngredient of(TagKey<Item> tag, MaterialVariantId material) {
        return MaterialIngredient.of(Ingredient.m_204132_(tag), material);
    }

    public static MaterialIngredient of(TagKey<Item> tag) {
        return MaterialIngredient.of(tag, (MaterialVariantId)WILDCARD);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        boolean hasMaterial;
        if (stack == null || stack.m_41619_() || !super.test(stack)) {
            return false;
        }
        boolean bl = hasMaterial = !WILDCARD.equals(this.material);
        if (hasMaterial || this.tag != null) {
            MaterialVariantId stackMaterial = IMaterialItem.getMaterialFromStack(stack);
            if (hasMaterial && !this.material.matchesVariant(stackMaterial)) {
                return false;
            }
            return this.tag == null || MaterialRegistry.getInstance().isInTag(stackMaterial.getId(), this.tag);
        }
        return true;
    }

    @Override
    public ItemStack[] m_43908_() {
        if (this.materialStacks == null) {
            if (!MaterialRegistry.isFullyLoaded()) {
                return this.nested.m_43908_();
            }
            Stream<Object> items = Arrays.stream(this.nested.m_43908_());
            if (!this.material.equals(WILDCARD)) {
                items = items.map(stack -> IMaterialItem.withMaterial(stack, this.material)).filter(ItemStack::m_41782_);
            } else {
                Collection<IMaterial> materials = this.tag != null ? MaterialRegistry.getInstance().getTagValues(this.tag) : MaterialRegistry.getMaterials();
                items = items.flatMap(stack -> materials.stream().map(mat -> IMaterialItem.withMaterial(stack, mat.getIdentifier())).filter(ItemStack::m_41782_));
            }
            this.materialStacks = (ItemStack[])items.distinct().toArray(ItemStack[]::new);
        }
        return this.materialStacks;
    }

    public JsonElement m_43942_() {
        JsonObject result;
        JsonElement parent = this.nested.m_43942_();
        if (this.nested.isVanilla() && parent.isJsonObject()) {
            result = parent.getAsJsonObject();
        } else {
            result = new JsonObject();
            result.add("match", parent);
        }
        result.addProperty("type", Serializer.ID.toString());
        Serializer.MATERIAL_FIELD.serialize((Object)this, result);
        Serializer.TAG_FIELD.serialize((Object)this, result);
        return result;
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.materialStacks = null;
    }

    @Override
    public boolean isSimple() {
        return this.material == WILDCARD && this.tag == null;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static enum Serializer implements IIngredientSerializer<MaterialIngredient>
    {
        INSTANCE;

        public static final ResourceLocation ID;
        private static final LoadableField<MaterialVariantId, MaterialIngredient> MATERIAL_FIELD;
        private static final LoadableField<TagKey<IMaterial>, MaterialIngredient> TAG_FIELD;

        public MaterialIngredient parse(JsonObject json) {
            Ingredient ingredient = json.has("match") ? CraftingHelper.getIngredient((JsonElement)json.get("match"), (boolean)false) : VanillaIngredientSerializer.INSTANCE.parse(json);
            return new MaterialIngredient(ingredient, (MaterialVariantId)MATERIAL_FIELD.get(json), (TagKey<IMaterial>)((TagKey)TAG_FIELD.get(json)));
        }

        public MaterialIngredient parse(FriendlyByteBuf buffer) {
            return new MaterialIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), (MaterialVariantId)MATERIAL_FIELD.decode(buffer), (TagKey<IMaterial>)((TagKey)TAG_FIELD.decode(buffer)));
        }

        public void write(FriendlyByteBuf buffer, MaterialIngredient ingredient) {
            ingredient.nested.m_43923_(buffer);
            MATERIAL_FIELD.encode(buffer, (Object)ingredient);
            TAG_FIELD.encode(buffer, (Object)ingredient);
        }

        static {
            ID = TConstruct.getResource("material");
            MATERIAL_FIELD = MaterialVariantId.LOADABLE.defaultField("material", (Object)WILDCARD, i -> i.material);
            TAG_FIELD = TinkerLoadables.MATERIAL_TAGS.nullableField("material_tag", i -> i.tag);
        }
    }
}

