/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.interaction.AreaOfEffectHighlightModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.BlockInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;

public interface BlockTransformModule
extends ModifierModule,
BlockInteractionModifierHook,
AreaOfEffectHighlightModifierHook {
    public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BLOCK_INTERACT, ModifierHooks.AOE_HIGHLIGHT);

    public boolean requireGround();

    @Override
    default public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    default public InteractionResult afterBlockUse(IToolStackView tool, ModifierEntry modifier, UseOnContext context, InteractionSource source) {
        if (tool.isBroken() || !tool.getHook(ToolHooks.INTERACTION).canInteract(tool, modifier.getId(), source)) {
            return InteractionResult.PASS;
        }
        Player player = context.m_43723_();
        if (player != null && player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (this.requireGround() && context.m_43719_() == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState original = world.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        boolean didTransform = this.transform(tool, context, original, true);
        EquipmentSlot slotType = source.getSlot(context.m_43724_());
        if (didTransform) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (ToolDamageUtil.damage(tool, 1, (LivingEntity)player, stack)) {
                if (player != null) {
                    player.m_21166_(slotType);
                }
                return InteractionResult.CONSUME;
            }
        }
        if (!tool.isBroken()) {
            int totalTransformed = 0;
            Iterator<BlockPos> aoePos = tool.getHook(ToolHooks.AOE_ITERATOR).getBlocks(tool, context, original, AreaOfEffectIterator.AOEMatchType.TRANSFORM).iterator();
            if (aoePos.hasNext()) {
                MutableUseOnContext offsetContext = new MutableUseOnContext(context);
                do {
                    BlockPos newPos;
                    if (pos.equals((Object)(newPos = aoePos.next()))) continue;
                    offsetContext.setOffsetPos(newPos);
                    BlockState newTarget = world.m_8055_(newPos);
                    if (!this.transform(tool, offsetContext, newTarget, totalTransformed < 40)) continue;
                    ++totalTransformed;
                    didTransform = true;
                    if (world.f_46443_) break;
                    if (!ToolDamageUtil.damage(tool, 1, (LivingEntity)player, context.m_43722_())) continue;
                    if (player == null) break;
                    player.m_21190_(context.m_43724_());
                    break;
                } while (aoePos.hasNext());
                if (totalTransformed > 0 && player != null) {
                    player.m_36346_();
                }
            }
        }
        return didTransform ? InteractionResult.m_19078_((boolean)world.f_46443_) : InteractionResult.PASS;
    }

    public boolean transform(IToolStackView var1, UseOnContext var2, BlockState var3, boolean var4);
}

