/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.item.BlockTooltipItem;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItemFluidHandler;

public class TankItem
extends BlockTooltipItem {
    private final boolean limitStackSize;

    public TankItem(Block blockIn, Item.Properties builder, boolean limitStackSize) {
        super(blockIn, builder);
        this.limitStackSize = limitStackSize;
    }

    private static boolean isFilled(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128425_("tank", 10);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return TankItem.isFilled(stack);
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return TankItem.isFilled(stack) ? new ItemStack((ItemLike)this) : ItemStack.f_41583_;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (!this.limitStackSize) {
            return super.getMaxStackSize(stack);
        }
        return TankItem.isFilled(stack) ? 16 : 64;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            FluidTank tank = TankItem.getFluidTank(stack);
            if (tank.getFluidAmount() > 0) {
                FluidStack fluid = tank.getFluid();
                tooltip.add((Component)fluid.getDisplayName().m_6879_().m_130940_(ChatFormatting.GRAY));
                FluidTooltipHandler.appendMaterial((FluidStack)fluid, tooltip);
            }
        } else {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TankItemFluidHandler(stack);
    }

    public static boolean mayHaveFluid(ItemStack stack) {
        return FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) || stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public boolean m_142207_(ItemStack held, Slot slot, ClickAction action, Player player) {
        ItemStack slotStack;
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !(slotStack = slot.m_7993_()).m_41619_() && TankItem.mayHaveFluid(slotStack)) {
            FluidTank tank;
            ItemStack result;
            if (slotStack.m_41613_() == 1 && (!(result = FluidTransferHelper.interactWithTankSlot((IFluidHandler)(tank = TankItem.getFluidTank(held)), (ItemStack)slotStack, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.REVERSE)).m_41619_() || slotStack.m_41619_())) {
                if (held.m_41613_() == 1) {
                    TankItem.setTank(held, tank);
                } else {
                    ItemStack split = held.m_41620_(1);
                    TankItem.setTank(split, tank);
                    if (!player.m_150109_().m_36054_(split)) {
                        player.m_36176_(split, false);
                    }
                }
                slot.m_5852_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)slotStack, (ItemStack)result));
            }
            return true;
        }
        return false;
    }

    public static void updateHeldItem(Player player, ItemStack held, ItemStack result) {
        if (player.f_36096_.m_142621_() == held) {
            player.f_36096_.m_142503_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)held, (ItemStack)result));
        } else if (!player.m_150109_().m_36054_(result)) {
            player.m_36176_(result, false);
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack held, Slot slot, ClickAction action, Player player, SlotAccess pAccess) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !held.m_41619_() && TankItem.mayHaveFluid(held)) {
            if (stack.m_41613_() == 1) {
                FluidTank tank = TankItem.getFluidTank(stack);
                int oldCount = held.m_41613_();
                ItemStack result = FluidTransferHelper.interactWithTankSlot((IFluidHandler)tank, (ItemStack)held, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.AUTO);
                if (!result.m_41619_() || held.m_41613_() != oldCount) {
                    TankItem.setTank(stack, tank);
                    TankItem.updateHeldItem(player, held, result);
                }
            }
            return true;
        }
        return false;
    }

    private static void removeTank(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            nbt.m_128473_("tank");
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public static ItemStack setTank(ItemStack stack, FluidTank tank) {
        if (tank.isEmpty()) {
            TankItem.removeTank(stack);
        } else {
            stack.m_41784_().m_128365_("tank", (Tag)tank.writeToNBT(new CompoundTag()));
        }
        return stack;
    }

    public static ItemStack setTank(ItemStack stack, FluidStack fluid) {
        if (fluid.isEmpty()) {
            TankItem.removeTank(stack);
        } else {
            stack.m_41784_().m_128365_("tank", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
        return stack;
    }

    private static ItemStack setTank(ItemLike item, ResourceLocation fluid, int amount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("FluidName", fluid.toString());
        tag.m_128405_("Amount", amount);
        ItemStack stack = new ItemStack(item);
        stack.m_41784_().m_128365_("tank", (Tag)tag);
        return stack;
    }

    public static FluidTank getFluidTank(ItemStack stack) {
        FluidTank tank = new FluidTank(TankBlockEntity.getCapacity(stack.m_41720_()));
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            tank.readFromNBT(stack.m_41783_().m_128469_("tank"));
        }
        return tank;
    }

    public static String getSubtype(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("tank", 10)) {
            return nbt.m_128469_("tank").m_128461_("FluidName");
        }
        return "";
    }

    public static void addFilledVariants(Consumer<ItemStack> output) {
        BuiltInRegistries.f_257020_.m_203611_().filter(holder -> {
            Fluid fluid = (Fluid)holder.get();
            return fluid.m_7444_(fluid.m_76145_()) && !holder.m_203656_(TinkerTags.Fluids.HIDE_IN_CREATIVE_TANKS);
        }).forEachOrdered(holder -> {
            SearedTankBlock.TankType gauge;
            SearedTankBlock.TankType tank;
            if (holder.m_203656_(TinkerTags.Fluids.METAL_TOOLTIPS)) {
                tank = SearedTankBlock.TankType.INGOT_TANK;
                gauge = SearedTankBlock.TankType.INGOT_GAUGE;
            } else {
                tank = SearedTankBlock.TankType.FUEL_TANK;
                gauge = SearedTankBlock.TankType.FUEL_GAUGE;
            }
            ResourceLocation fluidName = holder.m_205785_().m_135782_();
            output.accept(TankItem.setTank(TinkerSmeltery.searedLantern, fluidName, 50));
            output.accept(TankItem.fillTank(TinkerSmeltery.searedTank, tank, fluidName));
            output.accept(TankItem.fillTank(TinkerSmeltery.searedTank, gauge, fluidName));
            output.accept(TankItem.setTank(TinkerSmeltery.scorchedLantern, fluidName, 50));
            output.accept(TankItem.fillTank(TinkerSmeltery.scorchedTank, tank, fluidName));
            output.accept(TankItem.fillTank(TinkerSmeltery.scorchedTank, gauge, fluidName));
        });
    }

    public static ItemStack fillTank(EnumObject<SearedTankBlock.TankType, ? extends ItemLike> tank, SearedTankBlock.TankType type, Fluid fluid) {
        return TankItem.setTank(new ItemStack((ItemLike)tank.get((Enum)type)), new FluidStack(fluid, type.getCapacity()));
    }

    public static ItemStack fillTank(EnumObject<SearedTankBlock.TankType, ? extends ItemLike> tank, SearedTankBlock.TankType type, ResourceLocation fluid) {
        return TankItem.setTank((ItemLike)tank.get((Enum)type), fluid, type.getCapacity());
    }
}

