/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ArmorWalkModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record LightspeedAttributeModule(String unique, UUID uuid, Attribute attribute, AttributeModifier.Operation operation, @Nullable LightLayer lightLayer, int minLight, float amount, float damageChance) implements ModifierModule,
ArmorWalkModifierHook,
EquipmentChangeModifierHook,
TooltipModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOOT_WALK, ModifierHooks.EQUIPMENT_CHANGE, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<LightspeedAttributeModule> LOADER = RecordLoadable.create((RecordField)StringLoadable.DEFAULT.requiredField("unique", LightspeedAttributeModule::unique), (RecordField)Loadables.ATTRIBUTE.requiredField("attribute", LightspeedAttributeModule::attribute), (RecordField)TinkerLoadables.OPERATION.requiredField("operation", LightspeedAttributeModule::operation), (RecordField)TinkerLoadables.LIGHT_LAYER.nullableField("light_layer", LightspeedAttributeModule::lightLayer), (RecordField)IntLoadable.range((int)0, (int)14).requiredField("min_light", LightspeedAttributeModule::minLight), (RecordField)FloatLoadable.ANY.requiredField("per_level", LightspeedAttributeModule::amount), (RecordField)FloatLoadable.FROM_ZERO.requiredField("damage_chance", LightspeedAttributeModule::damageChance), LightspeedAttributeModule::new);

    public LightspeedAttributeModule(String unique, Attribute attribute, AttributeModifier.Operation operation, LightLayer lightLayer, int minLight, float amount, float damageChance) {
        this(unique, UUID.nameUUIDFromBytes(unique.getBytes()), attribute, operation, lightLayer, minLight, amount, damageChance);
    }

    public RecordLoadable<LightspeedAttributeModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private int getLight(Level level, BlockPos pos) {
        if (this.lightLayer == null) {
            return Math.max(level.m_45517_(LightLayer.BLOCK, pos), level.m_45517_(LightLayer.SKY, pos));
        }
        return level.m_45517_(this.lightLayer, pos);
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        Level level = living.m_9236_();
        if (tool.isBroken() || !living.m_20096_() || level.f_46443_) {
            return;
        }
        AttributeInstance attribute = living.m_21051_(this.attribute);
        if (attribute == null) {
            return;
        }
        if (attribute.m_22111_(this.uuid) != null) {
            attribute.m_22120_(this.uuid);
        }
        Vec3 vecPos = living.m_20182_();
        BlockPos pos = BlockPos.m_274561_((double)vecPos.f_82479_, (double)(vecPos.f_82480_ + 0.5), (double)vecPos.f_82481_);
        int light = this.getLight(level, pos);
        if (light > this.minLight) {
            int scaledLight = light - this.minLight;
            attribute.m_22118_(new AttributeModifier(this.uuid, this.unique, (double)((float)scaledLight * this.amount * modifier.getEffectiveLevel()), this.operation));
            if (level.f_46441_.m_188501_() < this.damageChance * (float)scaledLight) {
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET);
            }
        }
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        AttributeInstance attribute;
        IToolStackView newTool;
        LivingEntity livingEntity = context.getEntity();
        if (context.getChangedSlot() == EquipmentSlot.FEET && ((newTool = context.getReplacementTool()) == null || newTool.isBroken() || newTool.getModifier(modifier.getId()).getEffectiveLevel() != modifier.getEffectiveLevel()) && (attribute = livingEntity.m_21051_(this.attribute)) != null && attribute.m_22111_(this.uuid) != null) {
            attribute.m_22120_(this.uuid);
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        float boost;
        int light = 15;
        if (player != null && key == TooltipKey.SHIFT) {
            light = this.getLight(player.m_9236_(), player.m_20183_());
        }
        if ((boost = this.amount * (float)(light - this.minLight) * entry.getEffectiveLevel()) > 0.0f) {
            if (this.operation == AttributeModifier.Operation.ADDITION) {
                boost *= 10.0f;
            }
            Modifier modifier = entry.getModifier();
            TooltipModifierHook.addPercentBoost(modifier, modifier.getDisplayName(), boost, tooltip);
        }
    }
}

