/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierCrystalItem
extends Item {
    private static final Component TOOLTIP_MISSING = TConstruct.makeTranslation("item", "modifier_crystal.missing").m_130940_(ChatFormatting.GRAY);
    private static final Component TOOLTIP_APPLY = TConstruct.makeTranslation("item", "modifier_crystal.tooltip").m_130940_(ChatFormatting.GRAY);
    private static final String MODIFIER_KEY = TConstruct.makeTranslationKey("item", "modifier_crystal.modifier_id");
    private static final String TAG_MODIFIER = "modifier";

    public ModifierCrystalItem(Item.Properties props) {
        super(props);
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public Component m_7626_(ItemStack stack) {
        ModifierId modifier = ModifierCrystalItem.getModifier(stack);
        if (modifier != null) {
            return Component.m_237110_((String)(this.m_5671_(stack) + ".format"), (Object[])new Object[]{Component.m_237115_((String)Util.makeTranslationKey(TAG_MODIFIER, modifier))});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag advanced) {
        ModifierId id = ModifierCrystalItem.getModifier(stack);
        if (id != null) {
            if (ModifierManager.INSTANCE.contains(id)) {
                tooltip.addAll(ModifierManager.INSTANCE.get(id).getDescriptionList());
            }
            tooltip.add(TOOLTIP_APPLY);
            if (advanced.m_7050_()) {
                tooltip.add((Component)Component.m_237110_((String)MODIFIER_KEY, (Object[])new Object[]{id.toString()}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else {
            tooltip.add(TOOLTIP_MISSING);
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        ModifierId modifier = ModifierCrystalItem.getModifier(stack);
        if (modifier != null) {
            return modifier.m_135827_();
        }
        return null;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && (player.m_7500_() || player.m_20310_(2))) {
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            ItemStack toolItem = slot.m_7993_();
            if (modifier != null && !toolItem.m_41619_() && toolItem.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                if (!player.m_9236_().f_46443_ || player.m_7500_() && player.f_36096_.f_38843_ == null) {
                    ToolStack tool = ToolStack.copyFrom(toolItem);
                    tool.addModifier(modifier, stack.m_41613_());
                    Component toolValidation = tool.tryValidate();
                    if (toolValidation != null) {
                        player.m_5661_(toolValidation, false);
                    } else {
                        tool.updateStack(toolItem);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_142305_(ItemStack stack, ItemStack toolItem, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player) && !toolItem.m_41619_() && toolItem.m_204117_(TinkerTags.Items.MODIFIABLE) && (player.m_7500_() || player.m_20310_(2))) {
            ModifierId modifier = ModifierCrystalItem.getModifier(stack);
            if (modifier != null) {
                if (!player.m_9236_().f_46443_ || player.m_7500_() && player.f_36096_.f_38843_ == null) {
                    ToolStack original = ToolStack.from(toolItem);
                    ToolStack tool = original.copy();
                    ModifierEntry entry = tool.getUpgrades().getEntry(modifier);
                    if (entry.getLevel() <= 0) {
                        return true;
                    }
                    int newLevel = entry.getLevel() - stack.m_41613_();
                    if (newLevel <= 0) {
                        entry.getHook(ModifierHooks.RAW_DATA).removeRawData(tool, entry.getModifier(), tool.getRestrictedNBT());
                    }
                    tool.removeModifier(modifier, stack.m_41613_());
                    Component toolValidation = tool.tryValidate();
                    if (toolValidation != null) {
                        player.m_5661_(toolValidation, false);
                        return true;
                    }
                    toolValidation = ModifierRemovalHook.onRemoved(original, tool);
                    if (toolValidation != null) {
                        player.m_5661_(toolValidation, false);
                        return true;
                    }
                    tool.updateStack(toolItem);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static ItemStack withModifier(ModifierId modifier, int count) {
        ItemStack stack = new ItemStack(TinkerModifiers.modifierCrystal.get(), count);
        stack.m_41784_().m_128359_(TAG_MODIFIER, modifier.toString());
        return stack;
    }

    public static ItemStack withModifier(ModifierId modifier) {
        return ModifierCrystalItem.withModifier(modifier, 1);
    }

    @Nullable
    public static ModifierId getModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            return ModifierId.tryParse(tag.m_128461_(TAG_MODIFIER));
        }
        return null;
    }

    public static void addVariants(Consumer<ItemStack> items) {
        ModifierRecipeLookup.getRecipeModifierList().forEach(modifier -> {
            if (!ModifierManager.isInTag(modifier.getId(), TinkerTags.Modifiers.EXTRACT_MODIFIER_BLACKLIST)) {
                items.accept(ModifierCrystalItem.withModifier(modifier.getId()));
            }
        });
    }
}

