/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.registration.object.ItemObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerModule;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.config.ConfigurableAction;
import slimeknights.tconstruct.common.data.tags.MaterialTagProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.GeneratorPartTextureJsonGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPaletteDebugGenerator;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.library.client.data.material.TrimMaterialPaletteGenerator;
import slimeknights.tconstruct.library.client.data.spritetransformer.GreyToColorMapping;
import slimeknights.tconstruct.library.client.data.spritetransformer.ISpriteTransformer;
import slimeknights.tconstruct.library.client.data.spritetransformer.RecolorSpriteTransformer;
import slimeknights.tconstruct.library.json.loot.AddToolDataFunction;
import slimeknights.tconstruct.library.json.predicate.tool.HasMaterialPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.HasModifierPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.HasStatTypePredicate;
import slimeknights.tconstruct.library.json.predicate.tool.StatInRangePredicate;
import slimeknights.tconstruct.library.json.predicate.tool.StatInSetPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolContextPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackItemPredicate;
import slimeknights.tconstruct.library.json.predicate.tool.ToolStackPredicate;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.recipe.ingredient.ToolHookIngredient;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.ToolEnergyCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.ToolModule;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.BoxAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.CircleAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.ConditionalAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.TreeAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.aoe.VeiningAOEIterator;
import slimeknights.tconstruct.library.tools.definition.module.build.MultiplyStatsModule;
import slimeknights.tconstruct.library.tools.definition.module.build.SetStatsModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolActionsModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolSlotsModule;
import slimeknights.tconstruct.library.tools.definition.module.build.ToolTraitsModule;
import slimeknights.tconstruct.library.tools.definition.module.build.VolatileFlagModule;
import slimeknights.tconstruct.library.tools.definition.module.interaction.DualOptionInteraction;
import slimeknights.tconstruct.library.tools.definition.module.interaction.PreferenceSetInteraction;
import slimeknights.tconstruct.library.tools.definition.module.material.DefaultMaterialsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialRepairModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialStatsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.MaterialTraitsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.PartStatsModule;
import slimeknights.tconstruct.library.tools.definition.module.material.PartsModule;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveModule;
import slimeknights.tconstruct.library.tools.definition.module.mining.MaxTierHarvestLogic;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningSpeedModifierModule;
import slimeknights.tconstruct.library.tools.definition.module.mining.OneClickBreakModule;
import slimeknights.tconstruct.library.tools.definition.module.weapon.CircleWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.module.weapon.ParticleWeaponAttack;
import slimeknights.tconstruct.library.tools.definition.module.weapon.SweepWeaponAttack;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;
import slimeknights.tconstruct.library.tools.item.armor.MultilayerArmorItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableCrossbowItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.ArmorDefinitions;
import slimeknights.tconstruct.tools.ToolDefinitions;
import slimeknights.tconstruct.tools.data.ArmorModelProvider;
import slimeknights.tconstruct.tools.data.StationSlotLayoutProvider;
import slimeknights.tconstruct.tools.data.ToolDefinitionDataProvider;
import slimeknights.tconstruct.tools.data.ToolItemModelProvider;
import slimeknights.tconstruct.tools.data.ToolsRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.data.material.MaterialRecipeProvider;
import slimeknights.tconstruct.tools.data.material.MaterialRenderInfoProvider;
import slimeknights.tconstruct.tools.data.material.MaterialStatsDataProvider;
import slimeknights.tconstruct.tools.data.material.MaterialTraitsDataProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerMaterialSpriteProvider;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;
import slimeknights.tconstruct.tools.item.CrystalshotItem;
import slimeknights.tconstruct.tools.item.ModifiableSwordItem;
import slimeknights.tconstruct.tools.item.SlimeskullItem;
import slimeknights.tconstruct.tools.logic.EquipmentChangeWatcher;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;
import slimeknights.tconstruct.tools.modules.MeltingFluidEffectiveModule;

public final class TinkerTools
extends TinkerModule {
    public static final RegistryObject<CreativeModeTab> tabTools = CREATIVE_TABS.register("tools", () -> CreativeModeTab.builder().m_257941_((Component)TConstruct.makeTranslation("itemGroup", "tools")).m_257737_(() -> ((ModifiableItem)pickaxe.get()).getRenderTool()).m_257501_(TinkerTools::addTabItems).withTabsBefore(new ResourceLocation[]{TinkerTables.tabTables.getId()}).withSearchBar().m_257652_());
    public static final RegistryObject<LootItemFunctionType> lootAddToolData = LOOT_FUNCTIONS.register("add_tool_data", () -> new LootItemFunctionType((Serializer)AddToolDataFunction.SERIALIZER));
    public static final ItemObject<ModifiableItem> pickaxe = ITEMS.register("pickaxe", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.PICKAXE));
    public static final ItemObject<ModifiableItem> sledgeHammer = ITEMS.register("sledge_hammer", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.SLEDGE_HAMMER));
    public static final ItemObject<ModifiableItem> veinHammer = ITEMS.register("vein_hammer", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.VEIN_HAMMER));
    public static final ItemObject<ModifiableItem> mattock = ITEMS.register("mattock", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.MATTOCK));
    public static final ItemObject<ModifiableItem> pickadze = ITEMS.register("pickadze", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.PICKADZE));
    public static final ItemObject<ModifiableItem> excavator = ITEMS.register("excavator", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.EXCAVATOR));
    public static final ItemObject<ModifiableItem> handAxe = ITEMS.register("hand_axe", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.HAND_AXE));
    public static final ItemObject<ModifiableItem> broadAxe = ITEMS.register("broad_axe", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.BROAD_AXE));
    public static final ItemObject<ModifiableItem> kama = ITEMS.register("kama", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.KAMA));
    public static final ItemObject<ModifiableItem> scythe = ITEMS.register("scythe", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.SCYTHE));
    public static final ItemObject<ModifiableItem> dagger = ITEMS.register("dagger", () -> new ModifiableSwordItem(new Item.Properties().m_41503_(-1).m_41487_(2), ToolDefinitions.DAGGER, 2));
    public static final ItemObject<ModifiableItem> sword = ITEMS.register("sword", () -> new ModifiableSwordItem(UNSTACKABLE_PROPS, ToolDefinitions.SWORD));
    public static final ItemObject<ModifiableItem> cleaver = ITEMS.register("cleaver", () -> new ModifiableSwordItem(UNSTACKABLE_PROPS, ToolDefinitions.CLEAVER));
    public static final ItemObject<ModifiableCrossbowItem> crossbow = ITEMS.register("crossbow", () -> new ModifiableCrossbowItem(UNSTACKABLE_PROPS, ToolDefinitions.CROSSBOW));
    public static final ItemObject<ModifiableBowItem> longbow = ITEMS.register("longbow", () -> new ModifiableBowItem(UNSTACKABLE_PROPS, ToolDefinitions.LONGBOW));
    public static final ItemObject<ModifiableItem> flintAndBrick = ITEMS.register("flint_and_brick", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.FLINT_AND_BRICK));
    public static final ItemObject<ModifiableItem> skyStaff = ITEMS.register("sky_staff", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.SKY_STAFF));
    public static final ItemObject<ModifiableItem> earthStaff = ITEMS.register("earth_staff", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.EARTH_STAFF));
    public static final ItemObject<ModifiableItem> ichorStaff = ITEMS.register("ichor_staff", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.ICHOR_STAFF));
    public static final ItemObject<ModifiableItem> enderStaff = ITEMS.register("ender_staff", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.ENDER_STAFF));
    public static final ItemObject<ModifiableItem> meltingPan = ITEMS.register("melting_pan", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.MELTING_PAN));
    public static final ItemObject<ModifiableCrossbowItem> warPick = ITEMS.register("war_pick", () -> new ModifiableCrossbowItem(UNSTACKABLE_PROPS, ToolDefinitions.WAR_PICK));
    public static final ItemObject<ModifiableItem> battlesign = ITEMS.register("battlesign", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.BATTLESIGN));
    public static final ItemObject<ModifiableItem> swasher = ITEMS.register("swasher", () -> new ModifiableItem(UNSTACKABLE_PROPS, ToolDefinitions.SWASHER));
    public static final EnumObject<ArmorItem.Type, ModifiableArmorItem> travelersGear = ITEMS.registerEnum("travelers", (Enum[])ArmorItem.Type.values(), type -> new MultilayerArmorItem(ArmorDefinitions.TRAVELERS, (ArmorItem.Type)type, UNSTACKABLE_PROPS));
    public static final EnumObject<ArmorItem.Type, ModifiableArmorItem> plateArmor = ITEMS.registerEnum("plate", (Enum[])ArmorItem.Type.values(), type -> new MultilayerArmorItem(ArmorDefinitions.PLATE, (ArmorItem.Type)type, UNSTACKABLE_PROPS));
    public static final EnumObject<ArmorItem.Type, ModifiableArmorItem> slimesuit = new EnumObject.Builder(ArmorItem.Type.class).putAll(ITEMS.registerEnum("slime", (Enum[])new ArmorItem.Type[]{ArmorItem.Type.BOOTS, ArmorItem.Type.LEGGINGS, ArmorItem.Type.CHESTPLATE}, type -> new MultilayerArmorItem(ArmorDefinitions.SLIMESUIT, (ArmorItem.Type)type, UNSTACKABLE_PROPS))).put((Enum)ArmorItem.Type.HELMET, (Supplier)ITEMS.register("slime_helmet", () -> new SlimeskullItem(ArmorDefinitions.SLIMESUIT, UNSTACKABLE_PROPS))).build();
    public static final ItemObject<ModifiableItem> travelersShield = ITEMS.register("travelers_shield", () -> new ModifiableItem(UNSTACKABLE_PROPS, ArmorDefinitions.TRAVELERS_SHIELD));
    public static final ItemObject<ModifiableItem> plateShield = ITEMS.register("plate_shield", () -> new ModifiableItem(UNSTACKABLE_PROPS, ArmorDefinitions.PLATE_SHIELD));
    public static final ItemObject<ArrowItem> crystalshotItem = ITEMS.register("crystalshot", () -> new CrystalshotItem(ITEM_PROPS));
    public static final RegistryObject<SimpleParticleType> hammerAttackParticle = PARTICLE_TYPES.register("hammer_attack", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> axeAttackParticle = PARTICLE_TYPES.register("axe_attack", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> bonkAttackParticle = PARTICLE_TYPES.register("bonk", () -> new SimpleParticleType(true));
    public static final RegistryObject<EntityType<IndestructibleItemEntity>> indestructibleItem = ENTITIES.register("indestructible_item", () -> EntityType.Builder.m_20704_(IndestructibleItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20719_());
    public static final RegistryObject<EntityType<CrystalshotItem.CrystalshotEntity>> crystalshotEntity = ENTITIES.register("crystalshot", () -> EntityType.Builder.m_20704_(CrystalshotItem.CrystalshotEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20));
    public static final RegistryObject<MenuType<ToolContainerMenu>> toolContainer = MENUS.register("tool_container", ToolContainerMenu::forClient);

    public TinkerTools() {
        SlotType.init();
        BlockSideHitListener.init();
        ModifierLootingHandler.init();
        RandomMaterial.init();
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        EquipmentChangeWatcher.register();
        ToolCapabilityProvider.register(ToolFluidCapability.Provider::new);
        ToolCapabilityProvider.register(ToolInventoryCapability.Provider::new);
        ToolCapabilityProvider.register((stack, tool) -> new ToolEnergyCapability.Provider((Supplier<? extends IToolStackView>)tool));
        for (ConfigurableAction action : Config.COMMON.toolTweaks) {
            event.enqueueWork((Runnable)action);
        }
        ModifierHooks.init();
        ToolHooks.init();
    }

    @SubscribeEvent
    void registerRecipeSerializers(RegisterEvent event) {
        if (event.getRegistryKey() == Registries.f_256764_) {
            ItemPredicate.register((ResourceLocation)ToolStackItemPredicate.ID, ToolStackItemPredicate::deserialize);
            CraftingHelper.register((ResourceLocation)ToolHookIngredient.Serializer.ID, (IIngredientSerializer)ToolHookIngredient.Serializer.INSTANCE);
            ToolModule.LOADER.register(TConstruct.getResource("base_stats"), SetStatsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("multiply_stats"), MultiplyStatsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("tool_actions"), ToolActionsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("traits"), ToolTraitsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("modifier_slots"), ToolSlotsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("volatile_flag"), VolatileFlagModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("is_effective"), IsEffectiveModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("mining_speed_modifier"), MiningSpeedModifierModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("max_tier"), MaxTierHarvestLogic.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("one_click_break"), OneClickBreakModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("material_stats"), MaterialStatsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("part_stats"), PartStatsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("material_traits"), MaterialTraitsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("tool_parts"), PartsModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("material_repair"), MaterialRepairModule.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("default_materials"), DefaultMaterialsModule.LOADER);
            AreaOfEffectIterator.register(TConstruct.getResource("box_aoe"), BoxAOEIterator.LOADER);
            AreaOfEffectIterator.register(TConstruct.getResource("circle_aoe"), CircleAOEIterator.LOADER);
            AreaOfEffectIterator.register(TConstruct.getResource("tree_aoe"), TreeAOEIterator.LOADER);
            AreaOfEffectIterator.register(TConstruct.getResource("vein_aoe"), VeiningAOEIterator.LOADER);
            AreaOfEffectIterator.register(TConstruct.getResource("conditional_aoe"), ConditionalAOEIterator.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("sweep_melee"), SweepWeaponAttack.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("circle_melee"), CircleWeaponAttack.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("melee_particle"), ParticleWeaponAttack.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("dual_option_interaction"), DualOptionInteraction.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("preference_set_interaction"), PreferenceSetInteraction.LOADER);
            ToolModule.LOADER.register(TConstruct.getResource("melting_fluid_effective"), MeltingFluidEffectiveModule.LOADER);
            ToolContextPredicate.LOADER.register(TConstruct.getResource("has_upgrades"), ToolContextPredicate.HAS_UPGRADES.getLoader());
            ToolContextPredicate.LOADER.register(TConstruct.getResource("has_modifier"), HasModifierPredicate.LOADER);
            ToolContextPredicate.LOADER.register(TConstruct.getResource("has_material"), HasMaterialPredicate.LOADER);
            ToolContextPredicate.LOADER.register(TConstruct.getResource("has_stat_type"), HasStatTypePredicate.LOADER);
            ToolStackPredicate.LOADER.register(TConstruct.getResource("not_broken"), ToolStackPredicate.NOT_BROKEN.getLoader());
            ToolStackPredicate.LOADER.register(TConstruct.getResource("stat_in_range"), StatInRangePredicate.LOADER);
            ToolStackPredicate.LOADER.register(TConstruct.getResource("stat_in_set"), StatInSetPredicate.LOADER);
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        boolean client = event.includeClient();
        generator.addProvider(server, (DataProvider)new ToolsRecipeProvider(packOutput));
        generator.addProvider(server, (DataProvider)new MaterialRecipeProvider(packOutput));
        MaterialDataProvider materials = new MaterialDataProvider(packOutput);
        generator.addProvider(server, (DataProvider)materials);
        generator.addProvider(server, (DataProvider)new MaterialStatsDataProvider(packOutput, materials));
        generator.addProvider(server, (DataProvider)new MaterialTraitsDataProvider(packOutput, materials));
        generator.addProvider(server, (DataProvider)new ToolDefinitionDataProvider(packOutput));
        generator.addProvider(server, (DataProvider)new StationSlotLayoutProvider(packOutput));
        generator.addProvider(server, (DataProvider)new MaterialTagProvider(packOutput, existingFileHelper));
        generator.addProvider(client, (DataProvider)new ToolItemModelProvider(packOutput, existingFileHelper));
        TinkerMaterialSpriteProvider materialSprites = new TinkerMaterialSpriteProvider();
        TinkerPartSpriteProvider partSprites = new TinkerPartSpriteProvider();
        generator.addProvider(client, (DataProvider)new MaterialRenderInfoProvider(packOutput, materialSprites, existingFileHelper));
        generator.addProvider(client, (DataProvider)new GeneratorPartTextureJsonGenerator(packOutput, "tconstruct", partSprites));
        generator.addProvider(client, (DataProvider)new MaterialPartTextureGenerator(packOutput, existingFileHelper, (AbstractPartSpriteProvider)partSprites, materialSprites));
        generator.addProvider(client, (DataProvider)new MaterialPaletteDebugGenerator(packOutput, "tconstruct", materialSprites));
        generator.addProvider(client, (DataProvider)new ArmorModelProvider(packOutput));
        generator.addProvider(client, (DataProvider)new TrimMaterialPaletteGenerator(packOutput, "tconstruct", existingFileHelper, materialSprites, MaterialIds.TRIM_MATERIALS){

            @Override
            protected ISpriteTransformer getTransformer(MaterialId material) {
                if (MaterialIds.queensSlime.equals(material)) {
                    return new RecolorSpriteTransformer(GreyToColorMapping.builderFromBlack().addARGB(63, -10546944).addARGB(102, -7785984).addARGB(140, -6919677).addARGB(178, -7564762).addARGB(216, -11355309).addARGB(255, -10628001).build());
                }
                return super.getTransformer(material);
            }
        });
    }

    private static void addTabItems(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output tab) {
        Consumer<ItemStack> output = arg_0 -> ((CreativeModeTab.Output)tab).m_246342_(arg_0);
        TinkerTools.acceptTool(output, flintAndBrick);
        TinkerTools.acceptTool(output, skyStaff);
        TinkerTools.acceptTool(output, earthStaff);
        TinkerTools.acceptTool(output, ichorStaff);
        TinkerTools.acceptTool(output, enderStaff);
        TinkerTools.acceptTool(output, pickaxe);
        TinkerTools.acceptTool(output, pickadze);
        TinkerTools.acceptTool(output, mattock);
        TinkerTools.acceptTool(output, handAxe);
        TinkerTools.acceptTool(output, kama);
        TinkerTools.acceptTool(output, dagger);
        TinkerTools.acceptTool(output, sword);
        TinkerTools.acceptTool(output, sledgeHammer);
        TinkerTools.acceptTool(output, veinHammer);
        TinkerTools.acceptTool(output, excavator);
        TinkerTools.acceptTool(output, broadAxe);
        TinkerTools.acceptTool(output, scythe);
        TinkerTools.acceptTool(output, cleaver);
        TinkerTools.acceptTool(output, crossbow);
        TinkerTools.acceptTool(output, longbow);
        TinkerTools.acceptTool(output, meltingPan);
        TinkerTools.acceptTool(output, warPick);
        TinkerTools.acceptTool(output, battlesign);
        TinkerTools.acceptTool(output, swasher);
        TinkerTools.acceptTools(output, travelersGear);
        TinkerTools.acceptTool(output, travelersShield);
        TinkerTools.acceptTools(output, plateArmor);
        TinkerTools.acceptTool(output, plateShield);
        TinkerTools.acceptTools(output, slimesuit);
    }

    private static void acceptTool(Consumer<ItemStack> output, Supplier<? extends IModifiable> tool) {
        ToolBuildHandler.addVariants(output, tool.get(), "");
    }

    private static void acceptTools(Consumer<ItemStack> output, EnumObject<?, ? extends IModifiable> tools) {
        tools.forEach(tool -> ToolBuildHandler.addVariants(output, tool, ""));
    }
}

