/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.menu;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.fluid.FluidTransferHelper;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferManager;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.util.sync.ValidZeroDataSlot;
import slimeknights.tconstruct.shared.inventory.TriggeringMultiModuleContainerMenu;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.tank.SmelteryTank;
import slimeknights.tconstruct.smeltery.menu.TransferDirectionSupplier;
import slimeknights.tconstruct.tables.menu.module.SideInventoryContainer;

public class HeatingStructureContainerMenu
extends TriggeringMultiModuleContainerMenu<HeatingStructureBlockEntity>
implements TransferDirectionSupplier {
    private static final IFluidContainerTransfer.TransferDirection[] TRANSFER_DIRECTIONS = new IFluidContainerTransfer.TransferDirection[]{IFluidContainerTransfer.TransferDirection.AUTO, IFluidContainerTransfer.TransferDirection.EMPTY_ITEM, IFluidContainerTransfer.TransferDirection.FILL_ITEM};
    private final SideInventoryContainer<HeatingStructureBlockEntity> sideInventory;
    private final Container bucketContainer;
    private IFluidContainerTransfer.TransferDirection transferDirection = IFluidContainerTransfer.TransferDirection.AUTO;
    private final Slot bucketResultSlot;

    public HeatingStructureContainerMenu(int id, @Nullable Inventory inv, @Nullable HeatingStructureBlockEntity structure) {
        super((MenuType)TinkerSmeltery.smelteryContainer.get(), id, inv, structure);
        this.bucketContainer = new SimpleContainer(2);
        if (inv != null && structure != null) {
            if (!inv.f_35978_.m_9236_().f_46443_) {
                SmelteryTank<HeatingStructureBlockEntity> tank = structure.getTank();
                this.m_38897_(new BucketInputSlot(this.bucketContainer, 125, 46, tank, this));
                this.bucketResultSlot = this.m_38897_(new BucketResultSlot(this.bucketContainer, 125, 104, tank, this));
            } else {
                this.m_38897_(new BucketSlot(this.bucketContainer, 0, 125, 46));
                this.bucketResultSlot = this.m_38897_(new ResultSlot(this.bucketContainer, 1, 125, 104));
            }
            MeltingModuleInventory inventory = structure.getMeltingInventory();
            this.sideInventory = new SideInventoryContainer<HeatingStructureBlockEntity>((MenuType)TinkerSmeltery.smelteryContainer.get(), id, inv, structure, 0, 0, HeatingStructureContainerMenu.calcColumns(inventory.getSlots()));
            this.addSubContainer((AbstractContainerMenu)this.sideInventory, true);
            Consumer<DataSlot> referenceConsumer = x$0 -> this.m_38895_((DataSlot)x$0);
            ValidZeroDataSlot.trackIntArray(referenceConsumer, (ContainerData)structure.getFuelModule());
            inventory.trackInts(array -> ValidZeroDataSlot.trackIntArray((Consumer)referenceConsumer, (ContainerData)array));
        } else {
            this.sideInventory = null;
            this.bucketResultSlot = null;
        }
        this.addInventorySlots();
    }

    public HeatingStructureContainerMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (HeatingStructureBlockEntity)HeatingStructureContainerMenu.getTileEntityFromBuf((FriendlyByteBuf)buf, HeatingStructureBlockEntity.class));
    }

    protected int getInventoryYOffset() {
        return 138;
    }

    private void updateBucket(Player player) {
        ItemStack bucket;
        if (!player.m_9236_().f_46443_ && this.tile != null && !(bucket = this.bucketContainer.m_8020_(0)).m_41619_() && this.bucketContainer.m_8020_(1).m_41619_()) {
            ItemStack result = FluidTransferHelper.interactWithTankSlot(((HeatingStructureBlockEntity)this.tile).getTank(), (ItemStack)bucket, (IFluidContainerTransfer.TransferDirection)this.transferDirection);
            this.bucketContainer.m_6836_(0, bucket);
            this.bucketContainer.m_6836_(1, result);
            this.bucketContainer.m_6596_();
        }
    }

    public boolean m_6366_(Player player, int id) {
        if (player.m_5833_()) {
            return false;
        }
        if (id == 0) {
            this.transferDirection = TRANSFER_DIRECTIONS[(this.transferDirection.ordinal() + 1) % TRANSFER_DIRECTIONS.length];
            this.updateBucket(player);
            return true;
        }
        if (1 <= id && id <= 3) {
            ItemStack held = this.m_142621_();
            if (held.m_41619_()) {
                return false;
            }
            if (!player.m_9236_().f_46443_ && this.tile != null) {
                ItemStack result;
                if (id == 1) {
                    FuelModule fuelModule = ((HeatingStructureBlockEntity)this.tile).getFuelModule();
                    result = FluidTransferHelper.fillFromTankSlot((IFluidHandler)fuelModule, (ItemStack)held, (FluidStack)fuelModule.getLastFluid());
                } else {
                    result = FluidTransferHelper.interactWithTankSlot((IFluidHandler)(id == 2 ? ((HeatingStructureBlockEntity)this.tile).getFuelModule() : ((HeatingStructureBlockEntity)this.tile).getTank()), (ItemStack)held, (IFluidContainerTransfer.TransferDirection)IFluidContainerTransfer.TransferDirection.EMPTY_ITEM);
                }
                this.m_142503_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)held, (ItemStack)result));
            }
            return true;
        }
        if (id >= 4 && this.tile != null) {
            int index = id - 4;
            SmelteryTank<HeatingStructureBlockEntity> tank = ((HeatingStructureBlockEntity)this.tile).getTank();
            FluidStack fluid = tank.getFluidInTank(index);
            if (!fluid.isEmpty()) {
                if (!player.m_9236_().f_46443_) {
                    ItemStack held = this.m_142621_();
                    if (!held.m_41619_()) {
                        ItemStack result = FluidTransferHelper.fillFromTankSlot(tank, (ItemStack)held, (FluidStack)fluid);
                        this.m_142503_(FluidTransferHelper.getOrTransferFilled((Player)player, (ItemStack)held, (ItemStack)result));
                    } else {
                        tank.moveFluidToBottom(index);
                        this.updateBucket(player);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_) {
            this.m_150411_(player, this.bucketContainer);
        }
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return pSlot != this.bucketResultSlot && super.m_5882_(pStack, pSlot);
    }

    public static int calcColumns(int slots) {
        return Math.min(4, (slots + 6) / 7);
    }

    public SideInventoryContainer<HeatingStructureBlockEntity> getSideInventory() {
        return this.sideInventory;
    }

    public Container getBucketContainer() {
        return this.bucketContainer;
    }

    @Override
    public IFluidContainerTransfer.TransferDirection getTransferDirection() {
        return this.transferDirection;
    }

    public static class BucketInputSlot
    extends BucketSlot {
        private final IFluidHandler tank;
        private final TransferDirectionSupplier directionSupplier;

        public BucketInputSlot(Container pContainer, int pX, int pY, IFluidHandler tank, TransferDirectionSupplier directionSupplier) {
            super(pContainer, 0, pX, pY);
            this.tank = tank;
            this.directionSupplier = directionSupplier;
        }

        public void m_5852_(ItemStack stack) {
            if (!stack.m_41619_() && this.f_40218_.m_8020_(1).m_41619_()) {
                ItemStack result = FluidTransferHelper.interactWithTankSlot((IFluidHandler)this.tank, (ItemStack)stack, (IFluidContainerTransfer.TransferDirection)this.directionSupplier.getTransferDirection());
                this.f_40218_.m_6836_(1, result);
            }
            super.m_5852_(stack);
        }
    }

    public static class BucketResultSlot
    extends ResultSlot {
        private final IFluidHandler tank;
        private final TransferDirectionSupplier directionSupplier;

        public BucketResultSlot(Container pContainer, int pX, int pY, IFluidHandler tank, TransferDirectionSupplier directionSupplier) {
            super(pContainer, 1, pX, pY);
            this.tank = tank;
            this.directionSupplier = directionSupplier;
        }

        public void m_5852_(ItemStack stack) {
            ItemStack bucket;
            if (stack.m_41619_() && !(bucket = this.f_40218_.m_8020_(0)).m_41619_()) {
                stack = FluidTransferHelper.interactWithTankSlot((IFluidHandler)this.tank, (ItemStack)bucket, (IFluidContainerTransfer.TransferDirection)this.directionSupplier.getTransferDirection());
                this.f_40218_.m_6836_(0, bucket);
            }
            super.m_5852_(stack);
        }
    }

    public static class BucketSlot
    extends Slot {
        public BucketSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack stack) {
            return FluidContainerTransferManager.INSTANCE.mayHaveTransfer(stack) || stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
        }
    }

    public static class ResultSlot
    extends Slot {
        public ResultSlot(Container pContainer, int pSlot, int pX, int pY) {
            super(pContainer, pSlot, pX, pY);
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }
    }
}

