/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.menu.ToolContainerMenu;

public class ToolContainerScreen
extends AbstractContainerScreen<ToolContainerMenu> {
    private static final ResourceLocation TEXTURE = TConstruct.getResource("textures/gui/tool.png");
    private static final int REPEAT_BACKGROUND_ROWS = 6;
    private static final int PLAYER_INVENTORY_START = 125;
    private static final int PLAYER_INVENTORY_HEIGHT = 97;
    private static final int SLOTS_START = 238;
    private static final int SELECTED_X = 176;
    private final int slots;
    private final int inventoryRows;
    private final int slotsInLastRow;
    private final IToolStackView tool;

    public ToolContainerScreen(ToolContainerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        int slots = menu.getItemHandler().getSlots();
        if (menu.isShowOffhand()) {
            ++slots;
        }
        int inventoryRows = slots / 9;
        int slotsInLastRow = slots % 9;
        if (slotsInLastRow == 0) {
            slotsInLastRow = 9;
        } else {
            ++inventoryRows;
        }
        this.slots = slots;
        this.inventoryRows = inventoryRows;
        this.slotsInLastRow = slotsInLastRow;
        this.f_97727_ = 114 + this.inventoryRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
        this.tool = ToolStack.from(menu.getStack());
    }

    protected void m_6597_(Slot slot, int slotId, int index, ClickType type) {
        if (type == ClickType.SWAP && slot.f_40218_ == ((ToolContainerMenu)this.f_97732_).getPlayer().m_150109_() && slot.getSlotIndex() == ((ToolContainerMenu)this.f_97732_).getSlotIndex()) {
            return;
        }
        super.m_6597_(slot, slotId, index, type);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        Slot slot;
        int yOffset;
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        if (this.inventoryRows <= 6) {
            yOffset = this.inventoryRows * 18 + 17;
            graphics.m_280218_(TEXTURE, xStart, yStart, 0, 0, this.f_97726_, yOffset);
        } else {
            int remaining;
            yOffset = 125;
            graphics.m_280218_(TEXTURE, xStart, yStart, 0, 0, this.f_97726_, yOffset);
            int height = 108;
            for (remaining = this.inventoryRows - 6; remaining > 6; remaining -= 6) {
                graphics.m_280218_(TEXTURE, xStart, yStart + yOffset, 0, 17, this.f_97726_, height);
                yOffset += height;
            }
            height = remaining * 18;
            graphics.m_280218_(TEXTURE, xStart, yStart + yOffset, 0, 17, this.f_97726_, height);
            yOffset += height;
        }
        graphics.m_280218_(TEXTURE, xStart, yStart + yOffset, 0, 125, this.f_97726_, 97);
        int rowLeft = xStart + 7;
        int rowStart = yStart + 17 - 18;
        for (int i = 1; i < this.inventoryRows; ++i) {
            graphics.m_280218_(TEXTURE, rowLeft, rowStart + i * 18, 0, 238, 162, 18);
        }
        graphics.m_280218_(TEXTURE, rowLeft, rowStart + this.inventoryRows * 18, 0, 238, this.slotsInLastRow * 18, 18);
        int slotIndex = ((ToolContainerMenu)this.f_97732_).getSlotIndex();
        int highlightIndex = -1;
        if (slotIndex < 9) {
            highlightIndex = this.slots + slotIndex + 27;
        } else if (slotIndex < 36) {
            highlightIndex = this.slots + slotIndex - 9;
        } else if (slotIndex == 40 && ((ToolContainerMenu)this.f_97732_).isShowOffhand()) {
            highlightIndex = this.slots - 1;
        }
        if (highlightIndex != -1 && highlightIndex < ((ToolContainerMenu)this.f_97732_).f_38839_.size()) {
            Slot slot2 = ((ToolContainerMenu)this.f_97732_).m_38853_(highlightIndex);
            graphics.m_280218_(TEXTURE, xStart + slot2.f_40220_ - 2, yStart + slot2.f_40221_ - 2, 176, 0, 20, 20);
        }
        assert (this.f_96541_ != null);
        Function spriteGetter = this.f_96541_.m_91258_(InventoryMenu.f_39692_);
        int start = 0;
        int maxSlots = ((ToolContainerMenu)this.f_97732_).f_38839_.size();
        List<ModifierEntry> modifiers = this.tool.getModifierList();
        block2: for (int modIndex = modifiers.size() - 1; modIndex >= 0; --modIndex) {
            ModifierEntry entry = modifiers.get(modIndex);
            ToolInventoryCapability.InventoryModifierHook inventory = entry.getHook(ToolInventoryCapability.HOOK);
            int size = inventory.getSlots(this.tool, entry);
            for (int i = 0; i < size; ++i) {
                if (start + i >= maxSlots) break block2;
                Slot slot3 = ((ToolContainerMenu)this.f_97732_).m_38853_(start + i);
                Pattern pattern = inventory.getPattern(this.tool, entry, i, slot3.m_6657_());
                if (pattern == null) continue;
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(pattern.getTexture());
                graphics.m_280159_(xStart + slot3.f_40220_, yStart + slot3.f_40221_, 100, 16, 16, sprite);
            }
            start += size;
        }
        if (((ToolContainerMenu)this.f_97732_).isShowOffhand() && !(slot = ((ToolContainerMenu)this.f_97732_).m_38853_(this.slots - 1)).m_6657_()) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(Patterns.SHIELD.getTexture());
            graphics.m_280159_(xStart + slot.f_40220_, yStart + slot.f_40221_, 100, 16, 16, sprite);
        }
    }
}

