/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record DepthProtectionModule(IJsonPredicate<DamageSource> source, IJsonPredicate<LivingEntity> entity, float baselineHeight, float neutralRange, LevelingValue amount, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ProtectionModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROTECTION, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<DepthProtectionModule> LOADER = RecordLoadable.create((RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", DepthProtectionModule::source), (RecordField)LivingEntityPredicate.LOADER.defaultField("wearing_entity", DepthProtectionModule::entity), (RecordField)FloatLoadable.ANY.requiredField("baseline_height", DepthProtectionModule::baselineHeight), (RecordField)FloatLoadable.FROM_ZERO.requiredField("neutral_range", DepthProtectionModule::neutralRange), (RecordField)LevelingValue.LOADABLE.directField(DepthProtectionModule::amount), ModifierCondition.TOOL_FIELD, DepthProtectionModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public RecordLoadable<DepthProtectionModule> getLoader() {
        return LOADER;
    }

    public static float getBonusMultiplier(LivingEntity entity, float baselineHeight, float neutralRange) {
        float y = (float)entity.m_20186_();
        if (y < baselineHeight) {
            return Math.min((baselineHeight - y) / baselineHeight, 2.0f);
        }
        float debuffHeight = baselineHeight + neutralRange;
        if (y > debuffHeight) {
            return Math.max((debuffHeight - y) / baselineHeight, -1.0f);
        }
        return 0.0f;
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        LivingEntity target = context.getEntity();
        if (this.condition.matches(tool, modifier) && this.source.matches((Object)source) && this.entity.matches((Object)target)) {
            modifierValue += DepthProtectionModule.getBonusMultiplier(context.getEntity(), this.baselineHeight, this.neutralRange) * this.amount.compute(modifier.getEffectiveLevel());
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (this.condition.matches(tool, modifier)) {
            float multiplier = 0.0f;
            if (player == null || tooltipKey != TooltipKey.SHIFT) {
                multiplier = 1.0f;
            } else if (this.entity.matches((Object)player)) {
                multiplier = DepthProtectionModule.getBonusMultiplier((LivingEntity)player, this.baselineHeight, this.neutralRange);
            }
            if (multiplier != 0.0f) {
                ProtectionModule.addResistanceTooltip(tool, modifier.getModifier(), multiplier * this.amount.compute(modifier.getEffectiveLevel()), player, tooltip);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<DepthProtectionModule> {
        private IJsonPredicate<DamageSource> source = DamageSourcePredicate.CAN_PROTECT;
        private IJsonPredicate<LivingEntity> entity = LivingEntityPredicate.ANY;
        private float baselineHeight;
        private float neutralRange;

        @Override
        public DepthProtectionModule amount(float flat, float eachLevel) {
            return new DepthProtectionModule(this.source, this.entity, this.baselineHeight, this.neutralRange, new LevelingValue(flat, eachLevel), this.condition);
        }

        public Builder source(IJsonPredicate<DamageSource> source) {
            this.source = source;
            return this;
        }

        public Builder entity(IJsonPredicate<LivingEntity> entity) {
            this.entity = entity;
            return this;
        }

        public Builder baselineHeight(float baselineHeight) {
            this.baselineHeight = baselineHeight;
            return this;
        }

        public Builder neutralRange(float neutralRange) {
            this.neutralRange = neutralRange;
            return this;
        }
    }
}

