/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.module;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuelLookup;

public class FuelModule
implements ContainerData,
IFluidHandler {
    private static final BlockPos NULL_POS = new BlockPos(0, Short.MIN_VALUE, 0);
    private final NonNullConsumer<LazyOptional<IFluidHandler>> fluidListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset(true, (LazyOptional<?>)cap));
    private final NonNullConsumer<LazyOptional<IItemHandler>> itemListener = new WeakConsumerWrapper((Object)this, (self, cap) -> self.reset(true, (LazyOptional<?>)cap));
    private final MantleBlockEntity parent;
    private final Supplier<List<BlockPos>> tankSupplier;
    @Nullable
    private MeltingFuel lastRecipe;
    @Nullable
    private LazyOptional<IFluidHandler> fluidHandler;
    @Nullable
    private LazyOptional<IItemHandler> itemHandler;
    private BlockPos lastPos = NULL_POS;
    private Map<BlockPos, LazyOptional<IFluidHandler>> tankHandlers;
    private final NonNullConsumer<LazyOptional<IFluidHandler>> tankHandlerListener = new WeakConsumerWrapper((Object)this, (self, cap) -> {
        if (self.tankHandlers != null) {
            self.tankHandlers.values().remove(cap);
        }
    });
    private int fuel = 0;
    private int fuelQuality = 0;
    private int temperature = 0;
    private int rate = 0;
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelConsume = handler -> this.trySolidFuel((IItemHandler)handler, true);
    private final NonNullFunction<IItemHandler, Integer> trySolidFuelNoConsume = handler -> this.trySolidFuel((IItemHandler)handler, false);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, true);
    private final NonNullFunction<IFluidHandler, Integer> tryLiquidFuelNoConsume = handler -> this.tryLiquidFuel((IFluidHandler)handler, false);
    private static final String TAG_FUEL = "fuel";
    private static final String TAG_TEMPERATURE = "temperature";
    private static final String TAG_RATE = "rate";
    private static final String TAG_LAST_FUEL = "last_fuel";
    private static final int FUEL = 0;
    private static final int FUEL_QUALITY = 1;
    private static final int TEMPERATURE = 2;
    private static final int RATE = 6;
    private static final int LAST_X = 3;
    private static final int LAST_Y = 4;
    private static final int LAST_Z = 5;

    private void reset(boolean clearPos, @Nullable LazyOptional<?> source) {
        if (this.fluidHandler != null) {
            if (source != this.fluidHandler) {
                this.fluidHandler.removeListener(this.fluidListener);
            }
            this.fluidHandler = null;
        }
        if (this.itemHandler != null) {
            if (source != this.itemHandler) {
                this.itemHandler.removeListener(this.itemListener);
            }
            this.itemHandler = null;
        }
        if (clearPos) {
            this.lastPos = NULL_POS;
        }
    }

    public void clearFluidListeners() {
        if (this.tankHandlers != null) {
            for (LazyOptional<IFluidHandler> handler : this.tankHandlers.values()) {
                handler.removeListener(this.tankHandlerListener);
            }
            this.tankHandlers = null;
        }
    }

    private Level getLevel() {
        return Objects.requireNonNull(this.parent.m_58904_(), "Parent tile entity has null world");
    }

    private Map<BlockPos, LazyOptional<IFluidHandler>> getTankHandlers() {
        if (this.tankHandlers == null) {
            this.tankHandlers = new LinkedHashMap<BlockPos, LazyOptional<IFluidHandler>>();
            Level world = this.getLevel();
            for (BlockPos pos : this.tankSupplier.get()) {
                LazyOptional handler;
                BlockEntity te = world.m_7702_(pos);
                if (te == null || !(handler = te.getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) continue;
                handler.addListener(this.tankHandlerListener);
                this.tankHandlers.put(pos, (LazyOptional<IFluidHandler>)handler);
            }
        }
        return this.tankHandlers;
    }

    @Nullable
    private MeltingFuel findRecipe(Fluid fluid) {
        if (this.lastRecipe != null && this.lastRecipe.matches(fluid)) {
            return this.lastRecipe;
        }
        MeltingFuel recipe = MeltingFuelLookup.findFuel(fluid);
        if (recipe != null) {
            this.lastRecipe = recipe;
        }
        return recipe;
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    public void decreaseFuel(int amount) {
        this.fuel = Math.max(0, this.fuel - amount);
        this.parent.setChangedFast();
    }

    private int trySolidFuel(IItemHandler handler, boolean consume) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            int time = ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)((RecipeType)TinkerRecipeTypes.FUEL.get())) / 4;
            if (time <= 0) continue;
            MeltingFuel solid = MeltingFuelLookup.getSolid();
            if (consume) {
                ItemStack extracted = handler.extractItem(i, 1, false);
                if (ItemStack.m_41656_((ItemStack)extracted, (ItemStack)stack)) {
                    ItemStack notInserted;
                    this.fuel += time;
                    this.fuelQuality = time;
                    this.temperature = solid.getTemperature();
                    this.rate = solid.getRate();
                    this.parent.setChangedFast();
                    ItemStack container = extracted.getCraftingRemainingItem();
                    if (!container.m_41619_() && !(notInserted = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)container, (boolean)false)).m_41619_()) {
                        Level world = this.getLevel();
                        double x = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        double y = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        double z = (double)(world.f_46441_.m_188501_() * 0.5f) + 0.25;
                        BlockPos pos = this.lastPos == NULL_POS ? this.parent.m_58899_() : this.lastPos;
                        ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + x, (double)pos.m_123342_() + y, (double)pos.m_123343_() + z, container);
                        itementity.m_32060_();
                        world.m_7967_((Entity)itementity);
                    }
                } else {
                    TConstruct.LOG.error("Invalid item removed from solid fuel handler");
                }
            }
            return solid.getTemperature();
        }
        return 0;
    }

    private NonNullFunction<IItemHandler, Integer> trySolidFuel(boolean consume) {
        return consume ? this.trySolidFuelConsume : this.trySolidFuelNoConsume;
    }

    private int tryLiquidFuel(IFluidHandler handler, boolean consume) {
        FluidStack fluid = handler.getFluidInTank(0);
        MeltingFuel recipe = this.findRecipe(fluid.getFluid());
        if (recipe != null) {
            int amount = recipe.getAmount(fluid.getFluid());
            if (fluid.getAmount() >= amount) {
                if (consume) {
                    FluidStack drained = handler.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                    if (drained.getAmount() != amount) {
                        TConstruct.LOG.error("Invalid amount of fuel drained from tank");
                    }
                    this.fuel += recipe.getDuration();
                    this.fuelQuality = recipe.getDuration();
                    this.temperature = recipe.getTemperature();
                    this.rate = recipe.getRate();
                    this.parent.setChangedFast();
                    return this.temperature;
                }
                return recipe.getTemperature();
            }
        }
        return 0;
    }

    private NonNullFunction<IFluidHandler, Integer> tryLiquidFuel(boolean consume) {
        return consume ? this.tryLiquidFuelConsume : this.tryLiquidFuelNoConsume;
    }

    private int tryFindFuel(BlockPos pos, boolean consume) {
        LazyOptional<IFluidHandler> tankCap = this.getTankHandlers().get(pos);
        if (tankCap != null) {
            LazyOptional itemCap;
            Optional temperature = tankCap.map(this.tryLiquidFuel(consume));
            if (temperature.isPresent()) {
                this.reset(false, null);
                this.fluidHandler = tankCap;
                tankCap.addListener(this.fluidListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
            BlockEntity te = this.getLevel().m_7702_(pos);
            if (te != null && (temperature = (itemCap = te.getCapability(ForgeCapabilities.ITEM_HANDLER)).map(this.trySolidFuel(consume))).isPresent()) {
                this.reset(false, null);
                this.itemHandler = itemCap;
                itemCap.addListener(this.itemListener);
                this.lastPos = pos;
                return (Integer)temperature.get();
            }
        }
        return 0;
    }

    public int findFuel(boolean consume) {
        int posTemp;
        Optional handlerTemp = Optional.empty();
        if (this.fluidHandler != null) {
            handlerTemp = this.fluidHandler.map(this.tryLiquidFuel(consume));
        } else if (this.itemHandler != null) {
            handlerTemp = this.itemHandler.map(this.trySolidFuel(consume));
        } else if (this.lastPos != NULL_POS && (posTemp = this.tryFindFuel(this.lastPos, consume)) > 0) {
            return posTemp;
        }
        if (handlerTemp.orElse(0) > 0) {
            return (Integer)handlerTemp.get();
        }
        for (BlockPos pos : this.tankSupplier.get()) {
            int posTemp2;
            if (pos.equals((Object)this.lastPos) || (posTemp2 = this.tryFindFuel(pos, consume)) <= 0) continue;
            return posTemp2;
        }
        if (consume) {
            this.temperature = 0;
            this.rate = 0;
        }
        return 0;
    }

    public void readFromTag(CompoundTag nbt) {
        if (nbt.m_128425_(TAG_FUEL, 99)) {
            this.fuel = nbt.m_128451_(TAG_FUEL);
        }
        if (nbt.m_128425_(TAG_TEMPERATURE, 99)) {
            this.temperature = nbt.m_128451_(TAG_TEMPERATURE);
            this.rate = nbt.m_128451_(TAG_RATE);
        }
        if (nbt.m_128425_(TAG_LAST_FUEL, 10)) {
            this.lastPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(TAG_LAST_FUEL)).m_121955_((Vec3i)this.parent.m_58899_());
        }
    }

    public CompoundTag writeToTag(CompoundTag nbt) {
        nbt.m_128405_(TAG_FUEL, this.fuel);
        nbt.m_128405_(TAG_TEMPERATURE, this.temperature);
        nbt.m_128405_(TAG_RATE, this.rate);
        if (this.lastPos != NULL_POS) {
            nbt.m_128365_(TAG_LAST_FUEL, (Tag)NbtUtils.m_129224_((BlockPos)this.lastPos.m_121996_((Vec3i)this.parent.m_58899_())));
        }
        return nbt;
    }

    public int m_6499_() {
        return 6;
    }

    public int m_6413_(int index) {
        return switch (index) {
            case 0 -> this.fuel;
            case 1 -> this.fuelQuality;
            case 2 -> this.temperature;
            case 6 -> this.rate;
            case 3 -> this.lastPos.m_123341_();
            case 4 -> this.lastPos.m_123342_();
            case 5 -> this.lastPos.m_123343_();
            default -> 0;
        };
    }

    public void m_8050_(int index, int value) {
        switch (index) {
            case 0: {
                this.fuel = value;
                break;
            }
            case 1: {
                this.fuelQuality = value;
                break;
            }
            case 2: {
                this.temperature = value;
                break;
            }
            case 6: {
                this.rate = value;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                switch (index) {
                    case 3: {
                        this.lastPos = new BlockPos(value, this.lastPos.m_123342_(), this.lastPos.m_123343_());
                        break;
                    }
                    case 4: {
                        this.lastPos = new BlockPos(this.lastPos.m_123341_(), value, this.lastPos.m_123343_());
                        break;
                    }
                    case 5: {
                        this.lastPos = new BlockPos(this.lastPos.m_123341_(), this.lastPos.m_123342_(), value);
                    }
                }
                this.reset(false, null);
            }
        }
    }

    public FuelInfo getFuelInfo() {
        BlockPos mainTank = this.lastPos;
        if (mainTank.m_123342_() == NULL_POS.m_123342_()) {
            List<BlockPos> positions = this.tankSupplier.get();
            if (positions.isEmpty()) {
                return FuelInfo.EMPTY;
            }
            mainTank = positions.get(0);
            assert (mainTank != null);
        }
        if (this.fluidHandler == null && this.itemHandler == null) {
            LazyOptional<IFluidHandler> fluidCap = this.getTankHandlers().getOrDefault(mainTank, (LazyOptional<IFluidHandler>)LazyOptional.empty());
            if (fluidCap.isPresent()) {
                this.fluidHandler = fluidCap;
                this.fluidHandler.addListener(this.fluidListener);
            } else {
                LazyOptional itemCap;
                BlockEntity te = this.getLevel().m_7702_(mainTank);
                if (te != null && (itemCap = te.getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
                    this.itemHandler = itemCap;
                    this.itemHandler.addListener(this.itemListener);
                }
            }
        }
        if (this.fluidHandler == null) {
            this.fluidHandler = LazyOptional.empty();
        }
        if (this.itemHandler == null) {
            this.itemHandler = LazyOptional.empty();
        }
        if (this.itemHandler.isPresent()) {
            return FuelInfo.ITEM;
        }
        FuelInfo info = this.fluidHandler.map(handler -> {
            MeltingFuel fuel;
            FluidStack fluid = handler.getFluidInTank(0);
            int temperature = 0;
            if (!fluid.isEmpty() && (fuel = this.findRecipe(fluid.getFluid())) != null) {
                temperature = fuel.getTemperature();
            }
            return FuelInfo.of(fluid, handler.getTankCapacity(0), temperature);
        }).orElse(FuelInfo.EMPTY);
        if (!info.isEmpty()) {
            FluidStack currentFuel = info.getFluid();
            for (Map.Entry<BlockPos, LazyOptional<IFluidHandler>> entry : this.getTankHandlers().entrySet()) {
                if (mainTank.equals((Object)entry.getKey())) continue;
                entry.getValue().ifPresent(handler -> {
                    FluidStack fluid = handler.getFluidInTank(0);
                    if (fluid.isEmpty()) {
                        info.add(0, handler.getTankCapacity(0));
                    } else if (currentFuel.isFluidEqual(fluid)) {
                        info.add(fluid.getAmount(), handler.getTankCapacity(0));
                    }
                });
            }
        }
        return info;
    }

    public FluidStack getLastFluid() {
        BlockPos pos;
        if (this.fluidHandler != null && this.fluidHandler.isPresent()) {
            return ((IFluidHandler)this.fluidHandler.orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
        }
        if (this.lastPos.m_123342_() != NULL_POS.m_123342_()) {
            pos = this.lastPos;
        } else {
            List<BlockPos> positions = this.tankSupplier.get();
            if (!positions.isEmpty()) {
                pos = positions.get(0);
            } else {
                return FluidStack.EMPTY;
            }
        }
        return ((IFluidHandler)this.getTankHandlers().getOrDefault(pos, (LazyOptional<IFluidHandler>)LazyOptional.empty()).orElse((Object)EmptyFluidHandler.INSTANCE)).getFluidInTank(0);
    }

    public int getTanks() {
        return this.tankSupplier.get().size();
    }

    private IFluidHandler getTank(int tank) {
        List<BlockPos> positions;
        if (tank >= 0 && tank < (positions = this.tankSupplier.get()).size()) {
            return (IFluidHandler)this.getTankHandlers().getOrDefault(positions.get(tank), (LazyOptional<IFluidHandler>)LazyOptional.empty()).orElse((Object)EmptyFluidHandler.INSTANCE);
        }
        return EmptyFluidHandler.INSTANCE;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank(tank).getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.getTank(tank).getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.getTank(tank).isFluidValid(0, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFilled = 0;
        resource = resource.copy();
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            int filled = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).fill(resource, action);
            if (filled <= 0) continue;
            totalFilled += filled;
            if (filled >= resource.getAmount()) break;
            if (totalFilled == filled) {
                resource = new FluidStack(resource, resource.getAmount() - filled);
                continue;
            }
            resource.shrink(filled);
        }
        return totalFilled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            FluidStack drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(resource, action);
            if (drained.isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                drainedSoFar = drained;
                if (drained.getAmount() >= resource.getAmount()) break;
                resource = new FluidStack(resource, resource.getAmount() - drained.getAmount());
                continue;
            }
            drainedSoFar.grow(drained.getAmount());
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        for (LazyOptional<IFluidHandler> handler : this.getTankHandlers().values()) {
            FluidStack drained;
            if (toDrain.isEmpty()) {
                drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(maxDrain, action);
                if (drained.isEmpty()) continue;
                drainedSoFar = drained;
                if (drained.getAmount() >= maxDrain) break;
                toDrain = new FluidStack(drained, maxDrain - drained.getAmount());
                continue;
            }
            drained = ((IFluidHandler)handler.orElse((Object)EmptyFluidHandler.INSTANCE)).drain(toDrain, action);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }

    public FuelModule(MantleBlockEntity parent, Supplier<List<BlockPos>> tankSupplier) {
        this.parent = parent;
        this.tankSupplier = tankSupplier;
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelQuality() {
        return this.fuelQuality;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getRate() {
        return this.rate;
    }

    public static class FuelInfo {
        public static final FuelInfo EMPTY = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        public static final FuelInfo ITEM = new FuelInfo(FluidStack.EMPTY, 0, 0, 0);
        private final FluidStack fluid;
        private int totalAmount;
        private int capacity;
        private final int temperature;

        public static FuelInfo of(FluidStack fluid, int capacity, int temperature) {
            if (fluid.isEmpty()) {
                return EMPTY;
            }
            return new FuelInfo(fluid, fluid.getAmount(), Math.max(capacity, fluid.getAmount()), temperature);
        }

        protected void add(int amount, int capacity) {
            this.totalAmount += amount;
            this.capacity += capacity;
        }

        public boolean isItem() {
            return this == ITEM;
        }

        public boolean isEmpty() {
            return this.fluid.isEmpty() || this.totalAmount == 0 || this.capacity == 0;
        }

        public FluidStack getFluid() {
            return this.fluid;
        }

        public int getTotalAmount() {
            return this.totalAmount;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private FuelInfo(FluidStack fluid, int totalAmount, int capacity, int temperature) {
            this.fluid = fluid;
            this.totalAmount = totalAmount;
            this.capacity = capacity;
            this.temperature = temperature;
        }
    }
}

