/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.general;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;

public record DropItemFluidEffect(ItemOutput item) implements FluidEffect<FluidEffectContext>
{
    public static final RecordLoadable<DropItemFluidEffect> LOADER = ItemOutput.Loadable.REQUIRED_STACK.flatXmap(DropItemFluidEffect::new, DropItemFluidEffect::item);

    public DropItemFluidEffect(ItemLike item) {
        this(ItemOutput.fromItem((ItemLike)item));
    }

    @Override
    public RecordLoadable<DropItemFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext context, IFluidHandler.FluidAction action) {
        int count = (int)(level.value() * (float)this.item.getCount());
        if (count > 0) {
            if (action.execute()) {
                ModifierUtil.dropItem(context.getLevel(), context.getLocation(), ItemHandlerHelper.copyStackWithSize((ItemStack)this.item.get(), (int)(count * this.item.getCount())));
            }
            return (float)count / (float)this.item.getCount();
        }
        return 0.0f;
    }
}

