/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.fluid.block;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.fluid.EffectLevel;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;

public record PlaceBlockFluidEffect(@Nullable Block block, @Nullable SoundEvent sound) implements FluidEffect<FluidEffectContext.Block>
{
    public static final RecordLoadable<PlaceBlockFluidEffect> LOADER = RecordLoadable.create((RecordField)Loadables.BLOCK.nullableField("block", PlaceBlockFluidEffect::block), (RecordField)Loadables.SOUND_EVENT.nullableField("sound", PlaceBlockFluidEffect::sound), PlaceBlockFluidEffect::new);

    public PlaceBlockFluidEffect(@Nullable Block block) {
        this(block, null);
    }

    @Override
    public RecordLoadable<PlaceBlockFluidEffect> getLoader() {
        return LOADER;
    }

    @Override
    public float apply(FluidStack fluid, EffectLevel level, FluidEffectContext.Block context, IFluidHandler.FluidAction action) {
        if (level.isFull()) {
            ItemStack held;
            Block block = this.block;
            ItemStack stack = ItemStack.f_41583_;
            if (block != null) {
                stack = new ItemStack((ItemLike)block);
            } else {
                LivingEntity entity = context.getEntity();
                if (entity != null) {
                    for (InteractionHand hand : InteractionHand.values()) {
                        Item item;
                        held = entity.m_21120_(hand);
                        if (held.m_41619_() || !((item = held.m_41720_()) instanceof BlockItem)) continue;
                        BlockItem blockItem = (BlockItem)item;
                        block = blockItem.m_40614_();
                        stack = held;
                        break;
                    }
                }
            }
            if (block == null) {
                return 0.0f;
            }
            Player player = context.getPlayer();
            Level world = context.getLevel();
            BlockPlaceContext placeContext = new BlockPlaceContext(world, player, InteractionHand.MAIN_HAND, stack, context.getHitResult());
            BlockPos clicked = placeContext.m_8083_();
            if (placeContext.m_7059_()) {
                BlockState state;
                held = block.m_5456_();
                if (held instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)held;
                    if (action.execute()) {
                        if (blockItem.m_40576_(placeContext).m_19077_()) {
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                BlockState placed = world.m_8055_(clicked);
                                SoundType soundType = placed.getSoundType((LevelReader)world, clicked, (Entity)player);
                                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)Objects.requireNonNullElse(this.sound, soundType.m_56777_())), SoundSource.BLOCKS, (double)clicked.m_123341_(), (double)clicked.m_123342_(), (double)clicked.m_123343_(), (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f, TConstruct.RANDOM.nextLong()));
                            }
                            return 1.0f;
                        }
                        return 0.0f;
                    }
                    if ((placeContext = blockItem.m_7732_(placeContext)) == null) {
                        return 0.0f;
                    }
                }
                if ((state = block.m_5573_(placeContext)) == null) {
                    return 0.0f;
                }
                if (!state.m_60710_((LevelReader)world, clicked) || !world.m_45752_(state, clicked, player == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)player))) {
                    return 0.0f;
                }
                if (action.execute()) {
                    if (!world.m_7731_(clicked, state, 11)) {
                        return 0.0f;
                    }
                    BlockState placed = world.m_8055_(clicked);
                    if (placed.m_60713_(block)) {
                        block.m_6402_(world, clicked, placed, (LivingEntity)player, stack);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CriteriaTriggers.f_10591_.m_285767_(serverPlayer, clicked, stack);
                        }
                    }
                    LivingEntity placer = context.getEntity();
                    world.m_220407_(GameEvent.f_157797_, clicked, GameEvent.Context.m_223719_((Entity)placer, (BlockState)placed));
                    SoundType sound = placed.getSoundType((LevelReader)world, clicked, (Entity)placer);
                    world.m_5594_(null, clicked, Objects.requireNonNullElse(this.sound, sound.m_56777_()), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                    if (!(player != null && player.m_150110_().f_35937_ || stack.m_41619_())) {
                        stack.m_41774_(1);
                    }
                }
                return 1.0f;
            }
        }
        return 0.0f;
    }
}

