/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.client.screen.IScreenWithFluidTank;
import slimeknights.tconstruct.smeltery.client.screen.module.ClickableTankModule;
import slimeknights.tconstruct.smeltery.client.screen.module.GuiSmelteryTank;

public class GuiTankModule
implements IScreenWithFluidTank,
ClickableTankModule {
    private static final Component NO_CAPACITY = Component.m_237110_((String)Mantle.makeDescriptionId((String)"gui", (String)"fluid.millibucket"), (Object[])new Object[]{0}).m_130940_(ChatFormatting.GRAY);
    private static final int TANK_INDEX = 0;
    private final AbstractContainerScreen<?> screen;
    private final IFluidHandler tank;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final Rect2i fluidLoc;
    private final BiConsumer<Integer, List<Component>> formatter;

    public GuiTankModule(AbstractContainerScreen<?> screen, IFluidHandler tank, int x, int y, int width, int height, ResourceLocation tooltipId) {
        this.screen = screen;
        this.tank = tank;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fluidLoc = new Rect2i(x, y, width, height);
        this.formatter = (amount, tooltip) -> FluidTooltipHandler.appendNamedList((ResourceLocation)tooltipId, (int)amount, (List)tooltip);
    }

    @Override
    public AbstractContainerMenu getMenu() {
        return this.screen.m_6262_();
    }

    @Override
    public boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    @Override
    public boolean isFluidHovered(int checkY) {
        return checkY > this.y + this.height - this.getFluidHeight();
    }

    private int getFluidHeight() {
        int capacity = this.tank.getTankCapacity(0);
        if (capacity == 0) {
            return this.height;
        }
        return this.height * this.tank.getFluidInTank(0).getAmount() / capacity;
    }

    public void draw(GuiGraphics graphics) {
        GuiUtil.renderFluidTank(graphics.m_280168_(), this.screen, this.tank.getFluidInTank(0), this.tank.getTankCapacity(0), this.x, this.y, this.width, this.height, 100);
    }

    public void highlightHoveredFluid(GuiGraphics graphics, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            int fluidHeight = this.getFluidHeight();
            int middle = this.y + this.height - fluidHeight;
            if (checkY > middle) {
                GuiUtil.renderHighlight(graphics, this.x, middle, this.width, fluidHeight);
            } else {
                GuiUtil.renderHighlight(graphics, this.x, this.y, this.width, this.height - fluidHeight);
            }
        }
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        if (this.isHovered(checkX, checkY)) {
            ArrayList<Component> tooltip;
            FluidStack fluid = this.tank.getFluidInTank(0);
            int amount = fluid.getAmount();
            int capacity = this.tank.getTankCapacity(0);
            if (capacity > 0 && this.isFluidHovered(checkY)) {
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)fluid);
            } else {
                BiConsumer<Integer, List<Component>> formatter = Screen.m_96638_() ? FluidTooltipHandler.BUCKET_FORMATTER : this.formatter;
                tooltip = new ArrayList<Component>();
                tooltip.add(GuiSmelteryTank.TOOLTIP_CAPACITY);
                if (capacity == 0) {
                    tooltip.add(NO_CAPACITY);
                } else {
                    formatter.accept(capacity, tooltip);
                    if (capacity != amount) {
                        tooltip.add(GuiSmelteryTank.TOOLTIP_AVAILABLE);
                        formatter.accept(capacity - amount, tooltip);
                    }
                    FluidTooltipHandler.appendShift(tooltip);
                }
            }
            graphics.m_280666_(this.screen.f_96547_, tooltip, mouseX, mouseY);
        }
    }

    @Override
    public IScreenWithFluidTank.FluidLocation getFluidUnderMouse(int mouseX, int mouseY) {
        if (this.isHovered(mouseX, mouseY) && this.isFluidHovered(mouseY)) {
            return new IScreenWithFluidTank.FluidLocation(this.tank.getFluidInTank(0), this.fluidLoc);
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

