/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.fluid.FillOnlyFluidHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.ChannelBlock;
import slimeknights.tconstruct.smeltery.block.entity.tank.ChannelSideTank;
import slimeknights.tconstruct.smeltery.block.entity.tank.ChannelTank;
import slimeknights.tconstruct.smeltery.network.ChannelFlowPacket;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public class ChannelBlockEntity
extends MantleBlockEntity
implements FluidUpdatePacket.IFluidPacketReceiver {
    private final ChannelTank tank = new ChannelTank(30, this);
    private final LazyOptional<IFluidHandler> topHandler = LazyOptional.of(() -> new FillOnlyFluidHandler((IFluidHandler)this.tank));
    private final Map<Direction, IFluidHandler> sideTanks = (Map)Util.m_137469_(new EnumMap(Direction.class), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, new ChannelSideTank(this, this.tank, direction));
        }
    });
    private final Map<Direction, LazyOptional<IFluidHandler>> sideHandlers = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, LazyOptional<IFluidHandler>> emptySideHandler = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, LazyOptional<IFluidHandler>> neighborTanks = new EnumMap<Direction, LazyOptional<IFluidHandler>>(Direction.class);
    private final Map<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>> neighborConsumers = new EnumMap<Direction, NonNullConsumer<LazyOptional<IFluidHandler>>>(Direction.class);
    public static final BlockEntityTicker<ChannelBlockEntity> SERVER_TICKER = (level, pos, state, self) -> self.tick(state);
    private final byte[] isFlowing = new byte[5];
    private static final String TAG_IS_FLOWING = "is_flowing";
    private static final String TAG_TANK = "tank";

    public ChannelBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.channel.get(), pos, state);
    }

    protected ChannelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.f_58858_.m_123341_(), (double)(this.f_58858_.m_123342_() - 1), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1));
    }

    private void invalidateSide(Direction side, LazyOptional<IFluidHandler> capability) {
        if (!this.m_58901_() && this.neighborTanks.get(side) == capability) {
            this.neighborTanks.remove(side);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            if (side == null || side == Direction.UP) {
                return this.topHandler.cast();
            }
            if (side != Direction.DOWN) {
                ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)this.m_58900_().m_61143_((Property)ChannelBlock.DIRECTION_MAP.get(side)));
                if (connection == ChannelBlock.ChannelConnection.IN) {
                    return this.sideHandlers.computeIfAbsent(side, s -> LazyOptional.of(() -> this.sideTanks.get(s))).cast();
                }
                if (connection == ChannelBlock.ChannelConnection.OUT) {
                    return this.emptySideHandler.computeIfAbsent(side, s -> LazyOptional.of(() -> EmptyFluidHandler.INSTANCE)).cast();
                }
            }
        }
        return super.getCapability(capability, side);
    }

    private LazyOptional<IFluidHandler> getNeighborHandlerUncached(Direction side) {
        LazyOptional handler;
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (te != null && (handler = te.getCapability(ForgeCapabilities.FLUID_HANDLER, side.m_122424_())).isPresent()) {
            handler.addListener(this.neighborConsumers.computeIfAbsent(side, s -> new WeakConsumerWrapper((Object)this, (self, lazy) -> self.invalidateSide((Direction)s, (LazyOptional<IFluidHandler>)lazy))));
            return handler;
        }
        return LazyOptional.empty();
    }

    protected LazyOptional<IFluidHandler> getNeighborHandler(Direction side) {
        return this.neighborTanks.computeIfAbsent(side, this::getNeighborHandlerUncached);
    }

    public void removeCachedNeighbor(Direction side) {
        this.neighborTanks.remove(side);
    }

    public void refreshNeighbor(BlockState state, Direction side) {
        if (side == Direction.DOWN) {
            if (!((Boolean)state.m_61143_((Property)ChannelBlock.DOWN)).booleanValue()) {
                this.neighborTanks.remove(Direction.DOWN);
            }
        } else if (side != Direction.UP) {
            LazyOptional<IFluidHandler> handler;
            ChannelBlock.ChannelConnection connection = (ChannelBlock.ChannelConnection)((Object)state.m_61143_((Property)ChannelBlock.DIRECTION_MAP.get(side)));
            if (connection != ChannelBlock.ChannelConnection.OUT) {
                this.neighborTanks.remove(Direction.DOWN);
                handler = this.emptySideHandler.remove(side);
                if (handler != null) {
                    handler.invalidate();
                }
            }
            if (connection != ChannelBlock.ChannelConnection.IN && (handler = this.sideHandlers.remove(side)) != null) {
                handler.invalidate();
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.topHandler.invalidate();
        for (LazyOptional<IFluidHandler> handler : this.sideHandlers.values()) {
            if (handler == null) continue;
            handler.invalidate();
        }
        for (LazyOptional<IFluidHandler> handler : this.emptySideHandler.values()) {
            if (handler == null) continue;
            handler.invalidate();
        }
    }

    private int getFlowIndex(Direction side) {
        if (side.m_122434_().m_122478_()) {
            return 0;
        }
        return side.m_122411_() - 1;
    }

    public void setFlow(Direction side, boolean flowing) {
        if (side == Direction.UP) {
            return;
        }
        int index = this.getFlowIndex(side);
        boolean wasFlowing = this.isFlowing[index] > 0;
        this.isFlowing[index] = (byte)(flowing ? 2 : 0);
        if (wasFlowing != flowing && this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.syncFlowToClient(side, flowing);
        }
    }

    public boolean isFlowing(Direction side) {
        if (side == Direction.UP) {
            return false;
        }
        return this.isFlowing[this.getFlowIndex(side)] > 0;
    }

    protected boolean isOutput(Direction side) {
        if (side == Direction.UP) {
            return false;
        }
        if (side == Direction.DOWN) {
            return (Boolean)this.m_58900_().m_61143_((Property)ChannelBlock.DOWN);
        }
        return this.m_58900_().m_61143_((Property)ChannelBlock.DIRECTION_MAP.get(side)) == ChannelBlock.ChannelConnection.OUT;
    }

    private static int countOutputs(BlockState state) {
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (state.m_61143_((Property)ChannelBlock.DIRECTION_MAP.get(direction)) != ChannelBlock.ChannelConnection.OUT) continue;
            ++count;
        }
        return count;
    }

    private void syncFlowToClient(Direction side, boolean flowing) {
        TinkerNetwork.getInstance().sendToClientsAround(new ChannelFlowPacket(this.f_58858_, side, flowing), (LevelAccessor)this.f_58857_, this.f_58858_);
    }

    private void tick(BlockState state) {
        FluidStack fluid = this.tank.getFluid();
        if (!fluid.isEmpty()) {
            boolean hasFlown = false;
            if (((Boolean)state.m_61143_((Property)ChannelBlock.DOWN)).booleanValue()) {
                hasFlown = this.trySide(Direction.DOWN, 10);
            }
            int outputs = ChannelBlockEntity.countOutputs(state);
            if (!hasFlown && outputs > 0) {
                int flowRate = Mth.m_14045_((int)(this.tank.getMaxUsable() / outputs), (int)1, (int)10);
                for (Direction side : Direction.Plane.HORIZONTAL) {
                    this.trySide(side, flowRate);
                }
            }
        }
        for (int i = 0; i < 5; ++i) {
            if (this.isFlowing[i] <= 0) continue;
            int n = i;
            this.isFlowing[n] = (byte)(this.isFlowing[n] - 1);
            if (this.isFlowing[i] != 0) continue;
            Direction direction = i == 0 ? Direction.DOWN : Direction.m_122376_((int)(i + 1));
            this.syncFlowToClient(direction, false);
        }
        this.tank.freeFluid();
    }

    protected boolean trySide(Direction side, int flowRate) {
        if (this.tank.isEmpty() || !this.isOutput(side)) {
            return false;
        }
        return this.getNeighborHandler(side).filter(handler -> this.fill(side, (IFluidHandler)handler, flowRate)).isPresent();
    }

    protected boolean fill(Direction side, IFluidHandler handler, int amount) {
        FluidStack fluid;
        int filled;
        int usable = Math.min(this.tank.getMaxUsable(), amount);
        if (usable > 0 && (filled = handler.fill(fluid = this.tank.drain(usable, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
            fluid = this.tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            this.setFlow(side, true);
            return true;
        }
        this.setFlow(side, false);
        return false;
    }

    public void sendFluidUpdate() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            TinkerNetwork.getInstance().sendToClientsAround(new FluidUpdatePacket(this.f_58858_, this.getFluid()), (LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(CompoundTag nbt) {
        super.saveSynced(nbt);
        nbt.m_128382_(TAG_IS_FLOWING, this.isFlowing);
        nbt.m_128365_(TAG_TANK, (Tag)this.tank.writeToNBT(new CompoundTag()));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_(TAG_IS_FLOWING)) {
            byte[] nbtFlowing = nbt.m_128463_(TAG_IS_FLOWING);
            int max = Math.min(5, nbtFlowing.length);
            for (int i = 0; i < max; ++i) {
                int b = nbtFlowing[i];
                this.isFlowing[i] = b > 2 ? 2 : (b < 0 ? 0 : b);
            }
        }
        CompoundTag tankTag = nbt.m_128469_(TAG_TANK);
        this.tank.readFromNBT(tankTag);
    }
}

