/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.impl;

import net.minecraft.network.chat.Component;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.module.ModuleHookMap;

public class BasicModifier
extends Modifier {
    protected final ModifierLevelDisplay levelDisplay;
    protected final TooltipDisplay tooltipDisplay;
    protected final int priority;

    public BasicModifier(ModuleHookMap hookMap, ModifierLevelDisplay levelDisplay, TooltipDisplay tooltipDisplay, int priority) {
        super(hookMap);
        this.levelDisplay = levelDisplay;
        this.tooltipDisplay = tooltipDisplay;
        this.priority = priority;
    }

    @Override
    protected final void registerHooks(ModuleHookMap.Builder hookBuilder) {
    }

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return advanced ? this.tooltipDisplay != TooltipDisplay.NEVER : this.tooltipDisplay == TooltipDisplay.ALWAYS;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public static enum TooltipDisplay {
        ALWAYS,
        TINKER_STATION,
        NEVER;

    }

    public static class Builder {
        private final ModuleHookMap hookMap;
        private ModifierLevelDisplay levelDisplay = ModifierLevelDisplay.DEFAULT;
        private TooltipDisplay tooltipDisplay = TooltipDisplay.ALWAYS;
        private int priority = 100;

        public BasicModifier build() {
            return new BasicModifier(this.hookMap, this.levelDisplay, this.tooltipDisplay, this.priority);
        }

        public Builder levelDisplay(ModifierLevelDisplay levelDisplay) {
            this.levelDisplay = levelDisplay;
            return this;
        }

        public Builder tooltipDisplay(TooltipDisplay tooltipDisplay) {
            this.tooltipDisplay = tooltipDisplay;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        private Builder(ModuleHookMap hookMap) {
            this.hookMap = hookMap;
        }

        public static Builder builder(ModuleHookMap hookMap) {
            return new Builder(hookMap);
        }
    }
}

