/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.json.condition.TagDifferencePresentCondition;
import slimeknights.tconstruct.library.json.condition.TagIntersectionPresentCondition;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@CanIgnoreReturnValue
public class SmelteryRecipeBuilder {
    private final Consumer<FinishedRecipe> consumer;
    private final ResourceLocation name;
    @Nullable
    private final FluidObject<?> fluidObject;
    @Nullable
    private final Fluid fluid;
    @Nullable
    private final TagKey<Fluid> fluidTag;
    private int temperature;
    private boolean optional = false;
    private boolean hasOre = false;
    private IByproduct[] byproducts = new IByproduct[0];
    private String meltingFolder = "melting/";
    private String castingFolder = "casting/";
    private IMeltingContainer.OreRateType oreRate = null;
    private int baseUnit = 0;

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, FluidObject<?> fluid) {
        return new SmelteryRecipeBuilder(consumer, name, fluid, null, null).temperature(IMeltingRecipe.getTemperature(fluid));
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, @Nullable Fluid fluid, @Nullable TagKey<Fluid> fluidTag) {
        assert (fluid != null || fluidTag != null);
        SmelteryRecipeBuilder builder = new SmelteryRecipeBuilder(consumer, name, null, fluid, fluidTag);
        if (fluid != null) {
            builder.temperature(IMeltingRecipe.getTemperature(fluid));
        }
        return builder;
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, Fluid fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, name, fluid, null);
    }

    @CheckReturnValue
    public static SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, ResourceLocation name, TagKey<Fluid> fluidTag) {
        return SmelteryRecipeBuilder.fluid(consumer, name, null, fluidTag);
    }

    public SmelteryRecipeBuilder optional() {
        return this.optional(true);
    }

    public SmelteryRecipeBuilder byproducts(IByproduct ... byproducts) {
        this.byproducts = byproducts;
        this.hasOre = true;
        return this;
    }

    public SmelteryRecipeBuilder meltingFolder(String meltingFolder) {
        this.meltingFolder = meltingFolder + "/";
        return this;
    }

    public SmelteryRecipeBuilder castingFolder(String castingFolder) {
        this.castingFolder = castingFolder + "/";
        return this;
    }

    @CheckReturnValue
    private FluidOutput result(int amount) {
        if (this.fluidObject != null) {
            return this.fluidObject.result(amount);
        }
        if (this.fluid != null) {
            return FluidOutput.fromFluid((Fluid)this.fluid, (int)amount);
        }
        assert (this.fluidTag != null);
        return FluidOutput.fromTag(this.fluidTag, (int)amount);
    }

    @CheckReturnValue
    private FluidIngredient ingredient(int amount) {
        if (this.fluidObject != null) {
            return this.fluidObject.ingredient(amount);
        }
        if (this.fluidTag != null) {
            return FluidIngredient.of(this.fluidTag, (int)amount);
        }
        assert (this.fluid != null);
        return FluidIngredient.of((Fluid)this.fluid, (int)amount);
    }

    @CheckReturnValue
    public Consumer<FinishedRecipe> withCondition(ICondition ... conditions) {
        ConsumerWrapperBuilder builder = ConsumerWrapperBuilder.wrap();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder.build(this.consumer);
    }

    @CheckReturnValue
    public static ICondition tagCondition(String name) {
        return new NotCondition((ICondition)new TagEmptyCondition("forge", name));
    }

    @CheckReturnValue
    public static TagKey<Item> itemTag(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
    }

    @CheckReturnValue
    private ResourceLocation location(String folder, String variant) {
        return this.name.m_247449_(folder + this.name.m_135815_() + "/" + variant);
    }

    private void tagMelting(int amount, String output, float factor, String tagName, int damageUnit, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        MeltingRecipeBuilder builder = MeltingRecipeBuilder.melting(Ingredient.m_204132_(SmelteryRecipeBuilder.itemTag(tagName)), this.result(amount), this.temperature, factor);
        if (damageUnit > 0) {
            builder.setDamagable(damageUnit);
        }
        builder.save(wrapped, this.location(this.meltingFolder, output));
    }

    private void oreMelting(float scale, String tagName, @Nullable TagKey<Item> size, float factor, String output, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped;
        Ingredient ingredient;
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        Ingredient baseIngredient = Ingredient.m_204132_(SmelteryRecipeBuilder.itemTag(tagName));
        if (size == Tags.Items.ORE_RATES_SINGULAR) {
            ingredient = DifferenceIngredient.of((Ingredient)baseIngredient, (Ingredient)CompoundIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)Tags.Items.ORE_RATES_SPARSE), Ingredient.m_204132_((TagKey)Tags.Items.ORE_RATES_DENSE)}));
            wrapped = this.withCondition(TagDifferencePresentCondition.ofKeys(SmelteryRecipeBuilder.itemTag(tagName), Tags.Items.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_DENSE));
        } else if (size != null) {
            ingredient = IntersectionIngredient.of((Ingredient[])new Ingredient[]{baseIngredient, Ingredient.m_204132_(size)});
            wrapped = this.withCondition(TagIntersectionPresentCondition.ofKeys(SmelteryRecipeBuilder.itemTag(tagName), size));
        } else {
            ingredient = baseIngredient;
            wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        }
        Supplier<MeltingRecipeBuilder> supplier = () -> MeltingRecipeBuilder.melting(ingredient, this.result((int)((float)this.baseUnit * scale)), this.temperature, factor).setOre(this.oreRate, new IMeltingContainer.OreRateType[0]);
        ResourceLocation location = this.location(this.meltingFolder, output);
        if (this.byproducts.length == 0) {
            supplier.get().save(wrapped, location);
        } else if (this.byproducts[0].isAlwaysPresent()) {
            supplier.get().addByproduct(this.byproducts[0].getFluid(scale)).setOre(this.oreRate, this.byproducts[0].getOreRate()).save(wrapped, location);
        } else {
            ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
            boolean alwaysPresent = false;
            for (IByproduct byproduct : this.byproducts) {
                alwaysPresent = byproduct.isAlwaysPresent();
                if (alwaysPresent) {
                    builder.addCondition((ICondition)TrueCondition.INSTANCE);
                } else {
                    builder.addCondition(SmelteryRecipeBuilder.tagCondition("ingots/" + byproduct.getName()));
                }
                builder.addRecipe(supplier.get().addByproduct(byproduct.getFluid(scale)).setOre(this.oreRate, byproduct.getOreRate())::save);
                if (alwaysPresent) break;
            }
            if (!alwaysPresent) {
                builder.addCondition((ICondition)TrueCondition.INSTANCE);
                builder.addRecipe(supplier.get()::save);
            }
            builder.build(wrapped, location);
        }
    }

    private void tagCasting(int amount, String outputPrefix, CastItemObject cast, String tagName, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        ItemOutput output = ItemOutput.fromTag(SmelteryRecipeBuilder.itemTag(tagName));
        FluidIngredient fluid = this.ingredient(amount);
        ItemCastingRecipeBuilder.tableRecipe(output).setFluid(fluid).setCoolingTime(this.temperature, amount).setCast(cast.getMultiUseTag(), false).save(wrapped, this.location(this.castingFolder, outputPrefix + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluid(fluid).setCoolingTime(this.temperature, amount).setCast(cast.getSingleUseTag(), true).save(wrapped, this.location(this.castingFolder, outputPrefix + "_sand_cast"));
    }

    private void basinCasting(int amount, String output, String tagName, boolean forceOptional) {
        Consumer<FinishedRecipe> wrapped = this.optional || forceOptional ? this.withCondition(SmelteryRecipeBuilder.tagCondition(tagName)) : this.consumer;
        ItemCastingRecipeBuilder.basinRecipe(ItemOutput.fromTag(SmelteryRecipeBuilder.itemTag(tagName))).setFluid(this.ingredient(amount)).setCoolingTime(this.temperature, amount).save(wrapped, this.location(this.castingFolder, output));
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, String tagPrefix, CastItemObject cast, float factor, boolean forceOptional) {
        assert (this.baseUnit != 0);
        int amount = (int)((float)this.baseUnit * scale);
        String tagName = tagPrefix + "s/" + this.name.m_135815_();
        this.tagMelting(amount, tagPrefix, factor, tagName, 0, forceOptional);
        this.tagCasting(amount, tagPrefix, cast, tagName, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder meltingCasting(float scale, CastItemObject cast, float factor, boolean forceOptional) {
        return this.meltingCasting(scale, cast.getName().m_135815_(), cast, factor, forceOptional);
    }

    public SmelteryRecipeBuilder melting(float scale, String output, String tagPrefix, float factor, int damageUnit, boolean forceOptional) {
        assert (this.baseUnit != 0);
        this.tagMelting((int)((float)this.baseUnit * scale), output, factor, tagPrefix + "/" + this.name.m_135815_(), damageUnit, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder melting(float scale, String output, String tagPrefix, int damageUnit, boolean forceOptional) {
        assert (this.baseUnit != 0);
        this.tagMelting((int)((float)this.baseUnit * scale), output, (float)Math.sqrt(scale), tagPrefix + "/" + this.name.m_135815_(), damageUnit, forceOptional);
        return this;
    }

    public SmelteryRecipeBuilder melting(float scale, String tagPrefix, float factor, boolean forceOptional) {
        return this.melting(scale, tagPrefix, tagPrefix + "s", factor, 0, forceOptional);
    }

    public SmelteryRecipeBuilder rawOre() {
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        String name = this.name.m_135815_();
        this.oreMelting(1.0f, "raw_materials/" + name, null, 1.5f, "raw", false);
        this.oreMelting(9.0f, "storage_blocks/raw_" + name, null, 6.0f, "raw_block", false);
        return this;
    }

    public SmelteryRecipeBuilder sparseOre(float scale) {
        this.oreMelting(scale, "ores/" + this.name.m_135815_(), (TagKey<Item>)Tags.Items.ORE_RATES_SPARSE, 1.5f, "ore_sparse", false);
        return this;
    }

    public SmelteryRecipeBuilder singularOre(float scale) {
        this.oreMelting(scale, "ores/" + this.name.m_135815_(), (TagKey<Item>)Tags.Items.ORE_RATES_SINGULAR, 2.5f, "ore_singular", false);
        return this;
    }

    public SmelteryRecipeBuilder denseOre(float scale) {
        this.oreMelting(scale, "ores/" + this.name.m_135815_(), (TagKey<Item>)Tags.Items.ORE_RATES_DENSE, 4.5f, "ore_dense", false);
        return this;
    }

    public SmelteryRecipeBuilder metal() {
        this.oreRate = IMeltingContainer.OreRateType.METAL;
        this.baseUnit = 90;
        String name = this.name.m_135815_();
        this.tagMelting(810, "block", 3.0f, "storage_blocks/" + name, 0, false);
        this.basinCasting(810, "block", "storage_blocks/" + name, false);
        this.meltingCasting(1.0f, TinkerSmeltery.ingotCast, 1.0f, false);
        this.meltingCasting(0.11111111f, TinkerSmeltery.nuggetCast, 0.33333334f, false);
        if (this.hasOre) {
            this.rawOre();
            this.sparseOre(1.0f);
            this.singularOre(2.0f);
            this.denseOre(6.0f);
        }
        return this;
    }

    public SmelteryRecipeBuilder gem(int storageSize) {
        this.oreRate = IMeltingContainer.OreRateType.GEM;
        this.baseUnit = 100;
        String name = this.name.m_135815_();
        this.tagMelting(100 * storageSize, "block", (float)Math.sqrt(storageSize), "storage_blocks/" + name, 0, false);
        this.basinCasting(100 * storageSize, "block", "storage_blocks/" + name, false);
        this.meltingCasting(1.0f, TinkerSmeltery.gemCast, 1.0f, false);
        if (this.hasOre) {
            this.sparseOre(0.5f);
            this.singularOre(1.0f);
            this.denseOre(3.0f);
        }
        return this;
    }

    public SmelteryRecipeBuilder smallGem() {
        return this.gem(4);
    }

    public SmelteryRecipeBuilder largeGem() {
        return this.gem(9);
    }

    public SmelteryRecipeBuilder geore() {
        assert (this.oreRate != null);
        assert (this.baseUnit != 0);
        String name = this.name.m_135815_();
        this.tagMelting(this.baseUnit, "geore/shard", 1.0f, "geore_shards/" + name, 0, true);
        this.tagMelting(this.baseUnit * 4, "geore/block", 2.0f, "geore_blocks/" + name, 0, true);
        this.oreMelting(4.0f, "geore_clusters/" + name, null, 2.5f, "geore/cluster", true);
        this.oreMelting(1.0f, "geore_small_buds/" + name, null, 1.0f, "geore/bud_small", true);
        this.oreMelting(2.0f, "geore_medium_buds/" + name, null, 1.5f, "geore/bud_medium", true);
        this.oreMelting(3.0f, "geore_large_buds/" + name, null, 2.0f, "geore/bud_large", true);
        return this;
    }

    public SmelteryRecipeBuilder dust() {
        return this.melting(1.0f, "dust", 0.75f, true);
    }

    public SmelteryRecipeBuilder plate() {
        return this.meltingCasting(1.0f, TinkerSmeltery.plateCast, 1.0f, true);
    }

    public SmelteryRecipeBuilder gear() {
        return this.meltingCasting(4.0f, TinkerSmeltery.gearCast, 2.0f, true);
    }

    public SmelteryRecipeBuilder rod() {
        return this.meltingCasting(0.5f, TinkerSmeltery.rodCast, 0.2f, true);
    }

    public SmelteryRecipeBuilder sheetmetal() {
        return this.melting(1.0f, "sheetmetal", 1.0f, true);
    }

    public SmelteryRecipeBuilder coin() {
        return this.meltingCasting(0.33333334f, TinkerSmeltery.coinCast, 0.6666667f, true);
    }

    public SmelteryRecipeBuilder wire() {
        return this.meltingCasting(0.5f, TinkerSmeltery.wireCast, 0.2f, true);
    }

    public SmelteryRecipeBuilder armor() {
        int damageUnit = this.oreRate == IMeltingContainer.OreRateType.GEM ? 25 : 10;
        this.melting(5.0f, "helmet", "armors/boots", damageUnit, true);
        this.melting(8.0f, "chestplate", "armors/chestplates", damageUnit, true);
        this.melting(7.0f, "leggings", "armors/leggings", damageUnit, true);
        this.melting(4.0f, "boots", "armors/boots", damageUnit, true);
        return this;
    }

    public SmelteryRecipeBuilder paxel() {
        int damageUnit = this.oreRate == IMeltingContainer.OreRateType.GEM ? 25 : 10;
        return this.melting(7.0f, "paxel", "tools/paxels", damageUnit, true);
    }

    public SmelteryRecipeBuilder tools() {
        int damageUnit = this.oreRate == IMeltingContainer.OreRateType.GEM ? 25 : 10;
        this.melting(3.0f, "axe", "tools/axes", damageUnit, true);
        this.melting(2.0f, "hoe", "tools/hoes", damageUnit, true);
        this.melting(3.0f, "pickaxe", "tools/pickaxes", damageUnit, true);
        this.melting(1.0f, "shovel", "tools/shovels", damageUnit, true);
        this.melting(1.0f, "sword", "tools/swords", damageUnit, true);
        return this;
    }

    private SmelteryRecipeBuilder(Consumer<FinishedRecipe> consumer, ResourceLocation name, @Nullable FluidObject<?> fluidObject, @Nullable Fluid fluid, @Nullable TagKey<Fluid> fluidTag) {
        this.consumer = consumer;
        this.name = name;
        this.fluidObject = fluidObject;
        this.fluid = fluid;
        this.fluidTag = fluidTag;
    }

    public SmelteryRecipeBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public SmelteryRecipeBuilder optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public SmelteryRecipeBuilder hasOre(boolean hasOre) {
        this.hasOre = hasOre;
        return this;
    }

    public SmelteryRecipeBuilder oreRate(IMeltingContainer.OreRateType oreRate) {
        this.oreRate = oreRate;
        return this;
    }

    public SmelteryRecipeBuilder baseUnit(int baseUnit) {
        this.baseUnit = baseUnit;
        return this;
    }
}

