/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.recipe;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.library.data.recipe.ICastCreationHelper;
import slimeknights.tconstruct.library.data.recipe.SmelteryRecipeBuilder;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public interface ISmelteryRecipeHelper
extends ICastCreationHelper {
    default public SmelteryRecipeBuilder fluid(Consumer<FinishedRecipe> consumer, String name, FluidObject<?> fluid) {
        return SmelteryRecipeBuilder.fluid(consumer, this.location(name), fluid);
    }

    default public SmelteryRecipeBuilder molten(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid) {
        return this.fluid(consumer, fluid.getId().m_135815_().substring("molten_".length()), fluid);
    }

    default public void tagMelting(Consumer<FinishedRecipe> consumer, FluidOutput fluid, int temperature, String tagName, float factor, String recipePath, boolean isOptional) {
        Consumer wrapped = isOptional ? this.withCondition(consumer, new ICondition[]{this.tagCondition(tagName)}) : consumer;
        MeltingRecipeBuilder.melting(Ingredient.m_204132_((TagKey)this.getItemTag("forge", tagName)), fluid, temperature, factor).save(wrapped, this.location(recipePath));
    }

    default public void tagMelting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, String tagName, float factor, String recipePath, boolean isOptional) {
        this.tagMelting(consumer, fluid.result(amount), IMeltingRecipe.getTemperature(fluid), tagName, factor, recipePath, isOptional);
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, ItemOutput output, String location) {
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, amount).setCast(cast.getMultiUseTag(), false).save(consumer, this.location(location + "_gold_cast"));
        ItemCastingRecipeBuilder.tableRecipe(output).setFluidAndTime(fluid, amount).setCast(cast.getSingleUseTag(), true).save(consumer, this.location(location + "_sand_cast"));
    }

    default public void castingWithCast(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, ItemLike output, String location) {
        this.castingWithCast(consumer, fluid, amount, cast, ItemOutput.fromItem((ItemLike)output), location);
    }

    default public void tagCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, CastItemObject cast, String tagName, String recipeName, boolean optional) {
        if (optional) {
            consumer = this.withCondition(consumer, new ICondition[]{this.tagCondition(tagName)});
        }
        this.castingWithCast((Consumer<FinishedRecipe>)consumer, fluid, amount, cast, ItemOutput.fromTag((TagKey)this.getItemTag("forge", tagName)), recipeName);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, int amount, ItemLike ingot, String location) {
        this.castingWithCast(consumer, fluid, amount, TinkerSmeltery.ingotCast, ingot, location);
    }

    default public void ingotCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike ingot, String location) {
        this.ingotCasting(consumer, fluid, 90, ingot, location);
    }

    default public void gemCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike gem, String location) {
        this.castingWithCast(consumer, fluid, 100, TinkerSmeltery.gemCast, gem, location);
    }

    default public void nuggetCasting(Consumer<FinishedRecipe> consumer, FluidObject<?> fluid, ItemLike nugget, String location) {
        this.castingWithCast(consumer, fluid, 10, TinkerSmeltery.nuggetCast, nugget, location);
    }
}

