/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.ITinkerableContainer;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.item.ModifierCrystalItem;
import slimeknights.tconstruct.tools.recipe.ModifierRemovalRecipe;

public class ExtractModifierRecipe
extends ModifierRemovalRecipe {
    public static final String BASE_KEY = TConstruct.makeTranslationKey("recipe", "extract_modifier");
    private static final Component DESCRIPTION = TConstruct.makeTranslation("recipe", "extract_modifier.description");
    private static final Component NO_MODIFIERS = TConstruct.makeTranslation("recipe", "extract_modifier.no_modifiers");
    public static final RecordLoadable<ExtractModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)NAME_FIELD, (RecordField)TOOLS_FIELD, (RecordField)INPUTS_FIELD, (RecordField)LEFTOVERS_FIELD, (RecordField)MODIFIER_PREDICATE_FIELD, ExtractModifierRecipe::new);

    public ExtractModifierRecipe(ResourceLocation id, String name, SizedIngredient toolRequirements, List<SizedIngredient> inputs, List<ItemStack> leftovers, IJsonPredicate<ModifierId> modifierPredicate) {
        super(id, name, toolRequirements, inputs, leftovers, modifierPredicate);
    }

    @Override
    protected String getBaseKey() {
        return BASE_KEY;
    }

    @Override
    public Component getDescription(@Nullable ITinkerableContainer inv) {
        ToolStack tool;
        if (inv != null && this.filter(tool = inv.getTinkerable(), tool.getModifierList()).isEmpty()) {
            return NO_MODIFIERS;
        }
        return DESCRIPTION;
    }

    @Override
    protected List<ModifierEntry> filter(@Nullable IToolStackView tool, List<ModifierEntry> modifiers) {
        if (tool != null) {
            return modifiers.stream().filter(this.entryPredicate).filter(entry -> entry.intEffectiveLevel() > 0).toList();
        }
        return super.filter(tool, modifiers);
    }

    @Override
    public void updateInputs(LazyToolStack result, ITinkerableContainer.Mutable inv, ModifierEntry selected, boolean isServer) {
        super.updateInputs(result, inv, selected, isServer);
        if (isServer) {
            inv.giveItem(ModifierCrystalItem.withModifier(selected.getId()));
        }
    }

    @Override
    public boolean isModifierOutput() {
        return true;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.extractModifierSerializer.get();
    }
}

