/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.SoundUtils;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.TinkerStationBlock;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.TinkerStationContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.network.UpdateTinkerStationRecipePacket;

public class TinkerStationBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int TINKER_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    private static final Component NAME = TConstruct.makeTranslation("gui", "tinker_station");
    @Nullable
    private ITinkerStationRecipe lastRecipe;
    private final LazyResultContainer craftingResult;
    private final TinkerStationContainerWrapper inventoryWrapper;
    @Nullable
    private LazyToolStack result;
    @Nullable
    private Component currentError;
    private String itemName;

    public TinkerStationBlockEntity(BlockPos pos, BlockState state) {
        int n;
        Block block = state.m_60734_();
        if (block instanceof TinkerStationBlock) {
            TinkerStationBlock station = (TinkerStationBlock)block;
            n = station.getSlotCount();
        } else {
            n = 6;
        }
        this(pos, state, n);
    }

    public TinkerStationBlockEntity(BlockPos pos, BlockState state, int slots) {
        super((BlockEntityType)TinkerTables.tinkerStationTile.get(), pos, state, NAME, slots);
        this.result = null;
        this.currentError = null;
        this.itemName = "";
        this.itemHandler = new ConfigurableInvWrapperCapability((Container)this, false, false);
        this.itemHandlerCap = LazyOptional.of(() -> this.itemHandler);
        this.inventoryWrapper = new TinkerStationContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    public Component getDefaultName() {
        if (this.f_58857_ == null) {
            return super.getDefaultName();
        }
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public int getInputCount() {
        return this.m_6643_() - 1;
    }

    public LazyToolStack getTool() {
        return this.inventoryWrapper.getTool();
    }

    @Nullable
    public LazyToolStack getResult(@Nullable Player player) {
        this.craftingResult.getResult(player);
        return this.result;
    }

    public void resize(int size) {
        super.resize(size);
        this.inventoryWrapper.resize();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int menuId, Inventory playerInventory, Player playerEntity) {
        return new TinkerStationContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public ItemStack calcResult(@Nullable Player player) {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        this.result = null;
        this.currentError = null;
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_7654_() != null) {
            RecipeManager manager = this.f_58857_.m_7654_().m_129894_();
            ITinkerStationRecipe recipe = this.lastRecipe;
            if (recipe == null || !recipe.matches(this.inventoryWrapper, this.f_58857_)) {
                recipe = manager.m_44015_((RecipeType)TinkerRecipeTypes.TINKER_STATION.get(), (Container)this.inventoryWrapper, this.f_58857_).orElse(null);
            }
            boolean needsSync = true;
            if (recipe != null) {
                RecipeResult<LazyToolStack> validatedResult;
                if (this.lastRecipe != recipe) {
                    this.lastRecipe = recipe;
                    this.syncToRelevantPlayers(this::syncRecipe);
                    needsSync = false;
                }
                if ((validatedResult = recipe.getValidatedResult(this.inventoryWrapper, this.f_58857_.m_9598_())).isSuccess()) {
                    this.result = validatedResult.getResult();
                } else if (validatedResult.hasError()) {
                    this.currentError = validatedResult.getMessage();
                }
            }
            if (needsSync) {
                this.syncScreenToRelevantPlayers();
            }
        } else if (this.lastRecipe != null && this.lastRecipe.matches(this.inventoryWrapper, this.f_58857_)) {
            RecipeResult<LazyToolStack> validatedResult = this.lastRecipe.getValidatedResult(this.inventoryWrapper, this.f_58857_.m_9598_());
            if (validatedResult.isSuccess()) {
                this.result = validatedResult.getResult();
            } else if (validatedResult.hasError()) {
                this.currentError = validatedResult.getMessage();
            }
        }
        if (this.result != null) {
            if (!this.itemName.isEmpty()) {
                TooltipUtil.setDisplayName(this.result.getStack(), this.itemName);
            }
            return this.result.getStack();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void onCraft(Player player, ItemStack resultItem, int amount) {
        LazyToolStack result = this.result;
        if (amount == 0 || this.f_58857_ == null || this.lastRecipe == null || result == null) {
            return;
        }
        resultItem.m_41678_(this.f_58857_, player, amount);
        ForgeEventFactory.firePlayerCraftingEvent((Player)player, (ItemStack)resultItem, (Container)this.inventoryWrapper);
        this.playCraftSound(player);
        this.inventoryWrapper.setPlayer(player);
        this.lastRecipe.updateInputs(result, this.inventoryWrapper, !this.f_58857_.f_46443_);
        this.inventoryWrapper.setPlayer(null);
        ItemStack tinkerable = this.m_8020_(0);
        if (!tinkerable.m_41619_()) {
            int shrinkToolSlot = this.lastRecipe.shrinkToolSlotBy();
            if (tinkerable.m_41613_() <= shrinkToolSlot) {
                this.m_6836_(0, ItemStack.f_41583_);
            } else {
                this.m_6836_(0, ItemHandlerHelper.copyStackWithSize((ItemStack)tinkerable, (int)(tinkerable.m_41613_() - shrinkToolSlot)));
            }
        }
        this.itemName = "";
    }

    @Override
    public void m_6836_(int slot, ItemStack itemstack) {
        super.m_6836_(slot, itemstack);
        this.craftingResult.m_6211_();
        this.inventoryWrapper.refreshInput(slot);
    }

    @Override
    protected void playCraftSound(Player player) {
        if (this.isSoundReady(player)) {
            SoundUtils.playSoundForAll((Entity)player, this.getInputCount() > 4 ? SoundEvents.f_11671_ : Sounds.SAW.getSound(), 0.8f, 0.8f + 0.4f * player.m_217043_().m_188501_());
        }
    }

    public void setItemName(String name) {
        this.itemName = name;
        ItemStack result = this.craftingResult.getResult();
        if (!result.m_41619_()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                ItemStack input = this.m_8020_(0);
                name = !input.m_41619_() ? TooltipUtil.getDisplayName(input) : "";
            }
            TooltipUtil.setDisplayName(result, name);
        }
    }

    public void syncRecipe(Player player) {
        if (this.lastRecipe != null && this.f_58857_ != null && !this.f_58857_.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer server = (ServerPlayer)player;
            TinkerNetwork.getInstance().sendTo(new UpdateTinkerStationRecipePacket(this.f_58858_, this.lastRecipe), server);
        }
    }

    public void updateRecipe(ITinkerStationRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftingResult.m_6211_();
    }

    @Nullable
    public ITinkerStationRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    @Nullable
    public Component getCurrentError() {
        return this.currentError;
    }

    public String getItemName() {
        return this.itemName;
    }
}

