/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.UpdateToolDefinitionDataPacket;

public class ToolDefinitionLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger log = LogManager.getLogger(ToolDefinitionLoader.class);
    public static final String FOLDER = "tinkering/tool_definitions";
    private static final ToolDefinitionLoader INSTANCE = new ToolDefinitionLoader();
    private Map<ResourceLocation, ToolDefinitionData> dataMap = Collections.emptyMap();
    private final Map<ResourceLocation, ToolDefinition> definitions = new HashMap<ResourceLocation, ToolDefinition>();

    private ToolDefinitionLoader() {
        super(JsonHelper.DEFAULT_GSON, FOLDER);
    }

    public static ToolDefinitionLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::addDataPackListeners);
        MinecraftForge.EVENT_BUS.addListener(INSTANCE::onDatapackSync);
    }

    protected void updateDataFromServer(Map<ResourceLocation, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ToolDefinitionData data = dataMap.get(entry.getKey());
            ToolDefinition definition = entry.getValue();
            if (data != null) {
                definition.setData(data);
                continue;
            }
            definition.clearData();
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, ToolDefinition> entry : this.definitions.entrySet()) {
            ResourceLocation key = entry.getKey();
            ToolDefinition definition = entry.getValue();
            JsonElement element = splashList.get(key);
            if (element == null) {
                log.error("Missing tool definition for tool {}", (Object)key);
                definition.clearData();
                continue;
            }
            try {
                ToolDefinitionData data = (ToolDefinitionData)ToolDefinitionData.LOADABLE.convert(element, key.toString());
                builder.put((Object)key, (Object)data);
                definition.setData(data);
            }
            catch (Exception e) {
                log.error("Failed to load tool definition for tool {}", (Object)key, (Object)e);
                definition.clearData();
            }
        }
        this.dataMap = builder.build();
        log.info("Loaded {} tool definitions in {} ms", (Object)this.dataMap.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public Collection<ToolDefinition> getRegisteredToolDefinitions() {
        return this.definitions.values();
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        UpdateToolDefinitionDataPacket packet = new UpdateToolDefinitionDataPacket(this.dataMap);
        TinkerNetwork.getInstance().sendToPlayerList(event.getPlayer(), event.getPlayerList(), packet);
    }

    private void addDataPackListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }

    public synchronized void registerToolDefinition(ToolDefinition definition) {
        ResourceLocation name = definition.getId();
        if (this.definitions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate tool definition " + name);
        }
        this.definitions.put(name, definition);
    }
}

