/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.technical;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.util.LazyOptional;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public record SlotInChargeModule(TinkerDataCapability.TinkerDataKey<SlotInCharge> key) implements HookProvider,
EquipmentChangeModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.EQUIPMENT_CHANGE);
    private static final Function<TinkerDataCapability.TinkerDataKey<?>, SlotInCharge> CONSTRUCTOR = key -> new SlotInCharge();

    private static boolean toolValid(IToolStackView tool, EquipmentSlot slot, EquipmentChangeContext context) {
        if (!tool.isBroken() && !context.getEntity().m_9236_().f_46443_) {
            return ModifierUtil.validArmorSlot(tool, slot);
        }
        return false;
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if (SlotInChargeModule.toolValid(tool, slot, context)) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(this.key);
                if (slotInCharge != null) {
                    slotInCharge.removeSlot(slot);
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if (SlotInChargeModule.toolValid(tool, slot, context)) {
            context.getTinkerData().ifPresent(data -> data.computeIfAbsent(this.key, CONSTRUCTOR).addSlot(slot, modifier.getLevel()));
        }
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public static boolean isInCharge(LazyOptional<TinkerDataCapability.Holder> data, TinkerDataCapability.TinkerDataKey<SlotInCharge> key, EquipmentSlot slot) {
        return data.filter(d -> {
            SlotInCharge inCharge = (SlotInCharge)d.get(key);
            return inCharge != null && inCharge.inCharge == slot;
        }).isPresent();
    }

    public static int getLevel(LazyOptional<TinkerDataCapability.Holder> data, TinkerDataCapability.TinkerDataKey<SlotInCharge> key, EquipmentSlot slot) {
        return data.map(d -> {
            SlotInCharge inCharge = (SlotInCharge)d.get(key);
            return inCharge != null && inCharge.inCharge == slot ? inCharge.totalLevel : 0;
        }).orElse(0);
    }

    public static class SlotInCharge {
        private final int[] levels = new int[6];
        private int totalLevel = 0;
        @Nullable
        private EquipmentSlot inCharge = null;

        private SlotInCharge() {
        }

        private void addSlot(EquipmentSlot slotType, int level) {
            int index = slotType.m_20750_();
            this.totalLevel += level - this.levels[index];
            this.levels[index] = level;
            if (this.inCharge == null || this.inCharge.m_20743_() == EquipmentSlot.Type.HAND && slotType != EquipmentSlot.OFFHAND) {
                this.inCharge = slotType;
            }
        }

        private void removeSlot(EquipmentSlot slotType) {
            int index = slotType.m_20750_();
            this.totalLevel -= this.levels[index];
            this.levels[index] = 0;
            for (EquipmentSlot armorSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                if (this.levels[slotType.m_20750_()] <= 0) continue;
                this.inCharge = armorSlot;
                return;
            }
            for (EquipmentSlot hand : InteractionHandler.HAND_SLOTS) {
                if (this.levels[slotType.m_20750_()] <= 0) continue;
                this.inCharge = hand;
                return;
            }
            this.inCharge = null;
        }

        public int getTotalLevel() {
            return this.totalLevel;
        }

        @Nullable
        public EquipmentSlot getInCharge() {
            return this.inCharge;
        }
    }
}

