/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class EnderferenceModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
OnAttackedModifierHook {
    public EnderferenceModifier() {
        MinecraftForge.EVENT_BUS.addListener(EnderferenceModifier::onTeleport);
    }

    private static void onTeleport(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)TinkerModifiers.enderferenceEffect.get())) {
            event.setCanceled(true);
        }
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.ON_ATTACKED);
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        LivingEntity entity = context.getLivingTarget();
        if (entity != null) {
            ((TinkerEffect)((Object)TinkerModifiers.enderferenceEffect.get())).apply(entity, 1, 0, true);
        }
        return knockback;
    }

    @Override
    public void failedMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageAttempted) {
        LivingEntity entity = context.getLivingTarget();
        if (entity != null) {
            entity.m_21195_((MobEffect)TinkerModifiers.enderferenceEffect.get());
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity entity = context.getLivingTarget();
        if (entity != null) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TinkerModifiers.enderferenceEffect.get(), modifier.getLevel() * 100, 0, false, true, true));
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity entity;
        if (isDirectDamage && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            int level = modifier.getLevel();
            if (slotType.m_20743_() == EquipmentSlot.Type.HAND) {
                level *= 2;
            }
            if (RANDOM.nextFloat() < (float)level * 0.25f) {
                attacker.m_7292_(new MobEffectInstance((MobEffect)TinkerModifiers.enderferenceEffect.get(), modifier.getLevel() * 100, 0, false, true, true));
            }
        }
    }

    @Override
    public ProjectileImpactEvent.ImpactResult onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (target != null) {
            target.m_7292_(new MobEffectInstance((MobEffect)TinkerModifiers.enderferenceEffect.get(), modifier.getLevel() * 100, 0, false, true, true));
            if (target.m_6095_() == EntityType.f_20566_ && projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (arrow.m_36796_() > 0) {
                    if (arrow.f_36701_ == null) {
                        arrow.f_36701_ = new IntOpenHashSet(5);
                    }
                    if (arrow.f_36702_ == null) {
                        arrow.f_36702_ = Lists.newArrayListWithCapacity((int)5);
                    }
                    if (arrow.f_36701_.size() >= arrow.m_36796_() + 1) {
                        return ProjectileImpactEvent.ImpactResult.STOP_AT_CURRENT_NO_DAMAGE;
                    }
                    arrow.f_36701_.add(target.m_19879_());
                }
                int damage = Mth.m_14165_((double)Mth.m_14008_((double)(arrow.m_20184_().m_82553_() * arrow.m_36789_()), (double)0.0, (double)2.147483647E9));
                if (arrow.m_36792_()) {
                    damage = (int)Math.min((long)RANDOM.nextInt(damage / 2 + 2) + (long)damage, Integer.MAX_VALUE);
                }
                Entity owner = arrow.m_19749_();
                DamageSource damageSource = TinkerDamageTypes.source(projectile.m_9236_().m_9598_(), TinkerDamageTypes.MELEE_ARROW, (Entity)projectile, (Entity)attacker);
                if (attacker != null) {
                    attacker.m_21335_((Entity)target);
                }
                int remainingFire = target.m_20094_();
                if (arrow.m_6060_()) {
                    target.m_20254_(5);
                }
                Level level = arrow.m_9236_();
                if (target.m_6469_(damageSource, (float)damage)) {
                    Vec3 knockbackVec;
                    int knockback;
                    if (!level.f_46443_ && arrow.m_36796_() <= 0) {
                        target.m_21317_(target.m_21234_() + 1);
                    }
                    if ((knockback = arrow.m_150123_()) > 0 && (knockbackVec = arrow.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
                        target.m_5997_(knockbackVec.f_82479_, 0.1, knockbackVec.f_82481_);
                    }
                    if (!level.f_46443_ && attacker != null) {
                        EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)attacker);
                        EnchantmentHelper.m_44896_((LivingEntity)attacker, (Entity)target);
                    }
                    arrow.m_7761_(target);
                    if (!target.m_6084_() && arrow.f_36702_ != null) {
                        arrow.f_36702_.add(target);
                    }
                    if (!level.f_46443_ && arrow.m_36795_() && owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        if (arrow.f_36702_ != null) {
                            CriteriaTriggers.f_10556_.m_46871_(player, (Collection)arrow.f_36702_);
                        } else if (!target.m_6084_()) {
                            CriteriaTriggers.f_10556_.m_46871_(player, List.of(target));
                        }
                    }
                    arrow.m_5496_(arrow.f_36700_, 1.0f, 1.2f / (RANDOM.nextFloat() * 0.2f + 0.9f));
                    if (arrow.m_36796_() <= 0) {
                        return ProjectileImpactEvent.ImpactResult.STOP_AT_CURRENT_NO_DAMAGE;
                    }
                } else {
                    target.m_7311_(remainingFire);
                    arrow.m_20256_(arrow.m_20184_().m_82490_(-0.1));
                    arrow.m_146922_(arrow.m_146908_() + 180.0f);
                    arrow.f_19859_ += 180.0f;
                    if (!level.f_46443_ && arrow.m_20184_().m_82556_() < 1.0E-7) {
                        if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                            arrow.m_5552_(arrow.m_7941_(), 0.1f);
                        }
                        return ProjectileImpactEvent.ImpactResult.STOP_AT_CURRENT_NO_DAMAGE;
                    }
                }
                return ProjectileImpactEvent.ImpactResult.SKIP_ENTITY;
            }
        }
        return ProjectileImpactEvent.ImpactResult.DEFAULT;
    }
}

