/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;

public class GuiMeltingModule {
    private static final Component TOOLTIP_NO_HEAT = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_heat"));
    private static final Component TOOLTIP_NO_SPACE = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_space"));
    private static final Component TOOLTIP_UNMELTABLE = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.no_recipe"));
    private final AbstractContainerScreen<?> screen;
    private final MeltingModuleInventory inventory;
    private final IntSupplier temperature;
    private final Predicate<Slot> slotPredicate;
    private final ProgressBars progressBars;

    public GuiMeltingModule(AbstractContainerScreen<?> screen, MeltingModuleInventory inventory, IntSupplier temperature, Predicate<Slot> slotPredicate, ResourceLocation background) {
        this(screen, inventory, temperature, slotPredicate, GuiMeltingModule.makeProgressBars(background));
    }

    public void drawHeatBars(GuiGraphics graphics) {
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.m_6262_().f_38839_.get(i);
            if (!slot.m_6657_() || !this.slotPredicate.test(slot)) continue;
            ScalableElementScreen bar = this.progressBars.progress;
            int index = slot.getSlotIndex();
            int currentTemp = this.inventory.getCurrentTime(index);
            int requiredTime = this.inventory.getRequiredTime(index);
            float progress = 1.0f;
            if (requiredTime == 0) {
                bar = this.progressBars.unmeltable;
            } else if (this.inventory.getRequiredTemp(index) > temperature) {
                bar = this.progressBars.noHeat;
            } else if (currentTemp < 0) {
                bar = this.progressBars.noSpace;
            } else if (currentTemp <= requiredTime) {
                progress = (float)currentTemp / (float)requiredTime;
            }
            GuiUtil.drawProgressUp(graphics, (ElementScreen)bar, slot.f_40220_ - 4, slot.f_40221_, progress);
        }
    }

    public void drawHeatTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        int temperature = this.temperature.getAsInt();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Slot slot = (Slot)this.screen.m_6262_().f_38839_.get(i);
            if (!slot.m_6657_() || !this.slotPredicate.test(slot) || !GuiUtil.isHovered(checkX, checkY, slot.f_40220_ - 5, slot.f_40221_ - 1, this.progressBars.width() + 1, this.progressBars.height() + 2)) continue;
            int index = slot.getSlotIndex();
            Component tooltip = null;
            if (this.inventory.getRequiredTime(index) == 0) {
                tooltip = TOOLTIP_UNMELTABLE;
            } else if (this.inventory.getRequiredTemp(slot.getSlotIndex()) > temperature) {
                tooltip = TOOLTIP_NO_HEAT;
            } else if (this.inventory.getCurrentTime(index) < 0) {
                tooltip = TOOLTIP_NO_SPACE;
            }
            if (tooltip == null) break;
            graphics.m_280557_(this.screen.f_96547_, tooltip, mouseX, mouseY);
            break;
        }
    }

    public static ProgressBars makeProgressBars(ResourceLocation background) {
        return new ProgressBars(new ScalableElementScreen(background, 176, 150, 3, 16, 256, 256), new ScalableElementScreen(background, 179, 150, 3, 16, 256, 256), new ScalableElementScreen(background, 182, 150, 3, 16, 256, 256), new ScalableElementScreen(background, 185, 150, 3, 16, 256, 256));
    }

    public GuiMeltingModule(AbstractContainerScreen<?> screen, MeltingModuleInventory inventory, IntSupplier temperature, Predicate<Slot> slotPredicate, ProgressBars progressBars) {
        this.screen = screen;
        this.inventory = inventory;
        this.temperature = temperature;
        this.slotPredicate = slotPredicate;
        this.progressBars = progressBars;
    }

    public record ProgressBars(ScalableElementScreen progress, ScalableElementScreen noHeat, ScalableElementScreen noSpace, ScalableElementScreen unmeltable) {
        public ProgressBars {
            assert (ProgressBars.sameSize((ElementScreen)progress, (ElementScreen)noHeat));
            assert (ProgressBars.sameSize((ElementScreen)progress, (ElementScreen)noSpace));
            assert (ProgressBars.sameSize((ElementScreen)progress, (ElementScreen)unmeltable));
        }

        private static boolean sameSize(ElementScreen left, ElementScreen right) {
            return left.w == right.w && left.h == right.h && left.texW == right.texW && left.texH == right.texH;
        }

        public int width() {
            return this.progress.w;
        }

        public int height() {
            return this.progress.h;
        }
    }
}

