/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.data;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.recipe.data.ICommonRecipeHelper;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.data.BaseRecipeProvider;
import slimeknights.tconstruct.common.json.ConfigEnabledCondition;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.recipe.casting.ItemCastingRecipeBuilder;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.shared.block.ClearStainedGlassBlock;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.world.TinkerWorld;

public class CommonRecipeProvider
extends BaseRecipeProvider
implements ICommonRecipeHelper {
    public CommonRecipeProvider(PackOutput output) {
        super(output);
    }

    @Override
    public String m_6055_() {
        return "Tinkers' Construct Common Recipes";
    }

    @Override
    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        this.addCommonRecipes(consumer);
        this.addMaterialRecipes(consumer);
    }

    private void addCommonRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "common/firewood/";
        this.slabStairsCrafting(consumer, (BuildingBlockObject)TinkerMaterials.blazewood, folder, false);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)TinkerMaterials.blazewood.getFence(), (int)6).m_126130_("WWW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)TinkerMaterials.blazewood).m_126132_("has_planks", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)TinkerMaterials.blazewood)).m_126140_(consumer, this.location(folder + "blazewood_fence"));
        this.slabStairsCrafting(consumer, (BuildingBlockObject)TinkerMaterials.nahuatl, folder, false);
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)TinkerMaterials.nahuatl.getFence(), (int)6).m_126130_("WWW").m_126130_("WWW").m_126127_(Character.valueOf('W'), (ItemLike)TinkerMaterials.nahuatl).m_126132_("has_planks", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)TinkerMaterials.nahuatl)).m_126140_(consumer, this.location(folder + "nahuatl_fence"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, TinkerCommons.goldBars, (int)16).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_126130_("###").m_126130_("###").m_126132_("has_ingot", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_126140_(consumer, this.location("common/gold_bars"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, TinkerCommons.goldPlatform, (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('.'), Tags.Items.NUGGETS_GOLD).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_126132_("has_gold", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_126140_(consumer, this.location("common/gold_platform"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, TinkerCommons.ironPlatform, (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('.'), Tags.Items.NUGGETS_IRON).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_126132_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, this.location("common/iron_platform"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)TinkerCommons.copperPlatform.get((Enum)WeatheringCopper.WeatherState.UNAFFECTED)), (int)4).m_206416_(Character.valueOf('#'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('.'), TinkerTags.Items.NUGGETS_COPPER).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_126132_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_COPPER)).m_126140_(consumer, this.location("common/copper_platform"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, TinkerCommons.cobaltPlatform, (int)4).m_206416_(Character.valueOf('#'), TinkerMaterials.cobalt.getIngotTag()).m_206416_(Character.valueOf('.'), TinkerMaterials.cobalt.getNuggetTag()).m_126130_("#.#").m_126130_(". .").m_126130_("#.#").m_126132_("has_bars", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)TinkerMaterials.cobalt.getIngotTag())).m_126140_(consumer, this.location("common/cobalt_platform"));
        TinkerCommons.waxedCopperPlatform.forEach((age, block) -> {
            Block unwaxed = (Block)TinkerCommons.copperPlatform.get((Enum)age);
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)block).m_126209_((ItemLike)unwaxed).m_126209_((ItemLike)Items.f_42784_).m_126145_("tconstruct:wax_copper_platform").m_126132_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)unwaxed)).m_126140_(consumer, this.location("common/copper_platform_waxing_" + age.toString().toLowerCase(Locale.ROOT)));
        });
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, TinkerCommons.materialsAndYou).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerTables.pattern).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerTables.pattern)).m_126140_(consumer, this.prefix((IdAwareObject)TinkerCommons.materialsAndYou, "common/"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, TinkerCommons.tinkersGadgetry).m_126209_((ItemLike)Items.f_42517_).m_206419_(SlimeType.SKY.getSlimeballTag()).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_(SlimeType.SKY.getSlimeballTag())).m_126140_(consumer, this.prefix((IdAwareObject)TinkerCommons.tinkersGadgetry, "common/"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, TinkerCommons.punySmelting).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerSmeltery.grout).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerSmeltery.grout)).m_126140_(consumer, this.prefix((IdAwareObject)TinkerCommons.punySmelting, "common/"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.mightySmelting).setFluidAndTime((FluidObject<?>)TinkerFluids.searedStone, false, 250).setCast((ItemLike)Items.f_42517_, true).save(consumer, this.prefix((IdAwareObject)TinkerCommons.mightySmelting, "common/"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, TinkerCommons.fantasticFoundry).m_126209_((ItemLike)Items.f_42517_).m_126209_(TinkerSmeltery.netherGrout).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerSmeltery.netherGrout)).m_126140_(consumer, this.prefix((IdAwareObject)TinkerCommons.fantasticFoundry, "common/"));
        ItemCastingRecipeBuilder.tableRecipe(TinkerCommons.encyclopedia).setFluidAndTime((FluidObject<?>)TinkerFluids.moltenGold, true, 90).setCast((ItemLike)Items.f_42517_, true).save(consumer, this.prefix((IdAwareObject)TinkerCommons.encyclopedia, "common/"));
        folder = "common/glass/";
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, TinkerCommons.clearGlassPane, (int)16).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlass).m_126130_("###").m_126130_("###").m_126132_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlass)).m_126140_(consumer, this.prefix((IdAwareObject)TinkerCommons.clearGlassPane, folder));
        for (ClearStainedGlassBlock.GlassColor color : ClearStainedGlassBlock.GlassColor.values()) {
            Block block2 = (Block)TinkerCommons.clearStainedGlass.get((Enum)color);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)block2, (int)8).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlass).m_206416_(Character.valueOf('X'), color.getDye().getTag()).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_(this.prefix("stained_clear_glass")).m_126132_("has_clear_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlass)).m_126140_(consumer, this.prefix(this.id((ItemLike)block2), folder));
            Block pane = (Block)TinkerCommons.clearStainedGlassPane.get((Enum)color);
            ResourceLocation paneId = this.id((ItemLike)pane);
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pane, (int)16).m_126127_(Character.valueOf('#'), (ItemLike)block2).m_126130_("###").m_126130_("###").m_126145_(this.prefix("stained_clear_glass_pane")).m_126132_("has_block", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)block2)).m_126140_(consumer, this.prefix(paneId, folder));
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)pane, (int)8).m_126127_(Character.valueOf('#'), TinkerCommons.clearGlassPane).m_206416_(Character.valueOf('X'), color.getDye().getTag()).m_126130_("###").m_126130_("#X#").m_126130_("###").m_126145_(this.prefix("stained_clear_glass_pane")).m_126132_("has_clear_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.clearGlassPane)).m_126140_(consumer, this.wrap(paneId, folder, "_from_panes"));
        }
        String glassVanillaFolder = folder + "vanilla/";
        Consumer vanillaGlassConsumer = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.GLASS_RECIPE_FIX});
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50273_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42686_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_126127_(Character.valueOf('O'), (ItemLike)Blocks.f_50080_).m_126130_("GGG").m_126130_("GSG").m_126130_("OOO").m_126132_("has_nether_star", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42686_)).m_126140_(vanillaGlassConsumer, this.prefix(this.id((ItemLike)Blocks.f_50273_), glassVanillaFolder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.f_50329_).m_126127_(Character.valueOf('Q'), (ItemLike)Items.f_42692_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_206416_(Character.valueOf('W'), ItemTags.f_13175_).m_126130_("GGG").m_126130_("QQQ").m_126130_("WWW").m_126132_("has_quartz", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42692_)).m_126140_(vanillaGlassConsumer, this.prefix(this.id((ItemLike)Blocks.f_50329_), glassVanillaFolder));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.f_42729_).m_126127_(Character.valueOf('T'), (ItemLike)Items.f_42586_).m_126127_(Character.valueOf('E'), (ItemLike)Items.f_42545_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_COLORLESS).m_126130_("GGG").m_126130_("GEG").m_126130_("GTG").m_126132_("has_ender_eye", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Items.f_42545_)).m_126140_(vanillaGlassConsumer, this.prefix(this.id((ItemLike)Items.f_42729_), glassVanillaFolder));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BREWING, (ItemLike)Items.f_42590_, (int)3).m_206416_(Character.valueOf('#'), Tags.Items.GLASS_COLORLESS).m_126130_("# #").m_126130_(" # ").m_126132_("has_glass", (CriterionTriggerInstance)CommonRecipeProvider.m_206406_((TagKey)Tags.Items.GLASS_COLORLESS)).m_126140_(vanillaGlassConsumer, this.prefix(this.id((ItemLike)Items.f_42590_), glassVanillaFolder));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42484_).m_126209_((ItemLike)Blocks.f_49994_).m_126209_((ItemLike)Blocks.f_49994_).m_126209_((ItemLike)Blocks.f_49994_).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Blocks.f_49994_)).m_126140_(ConsumerWrapperBuilder.wrap().addCondition((ICondition)ConfigEnabledCondition.GRAVEL_TO_FLINT).build(consumer), this.location("common/flint"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.f_50620_).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_152597_).m_126127_(Character.valueOf('X'), (ItemLike)Blocks.f_50094_).m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42416_).m_126130_("III").m_126130_("IXI").m_126130_("###").m_126132_("has_smooth_stone", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_((ItemLike)Blocks.f_152597_)).m_126140_(consumer, this.location("common/basalt_blast_furnace"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, TinkerCommons.cheeseBlock).m_126127_(Character.valueOf('#'), TinkerCommons.cheeseIngot).m_126130_("##").m_126130_("##").m_126132_("has_cheese", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.cheeseIngot)).m_126140_(consumer, this.location("common/cheese_block_from_ingot"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.FOOD, TinkerCommons.cheeseIngot, (int)4).m_126209_(TinkerCommons.cheeseBlock).m_126132_("has_cheese", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerCommons.cheeseBlock)).m_126140_(consumer, this.location("common/cheese_ingot_from_block"));
    }

    private void addMaterialRecipes(Consumer<FinishedRecipe> consumer) {
        String folder = "common/materials/";
        this.metalCrafting(consumer, TinkerMaterials.cobalt, folder);
        this.metalCrafting(consumer, TinkerMaterials.slimesteel, folder);
        this.metalCrafting(consumer, TinkerMaterials.amethystBronze, folder);
        this.metalCrafting(consumer, TinkerMaterials.roseGold, folder);
        this.metalCrafting(consumer, TinkerMaterials.pigIron, folder);
        this.metalCrafting(consumer, TinkerMaterials.queensSlime, folder);
        this.metalCrafting(consumer, TinkerMaterials.manyullyn, folder);
        this.metalCrafting(consumer, TinkerMaterials.hepatizon, folder);
        this.packingRecipe(consumer, RecipeCategory.MISC, "ingot", (ItemLike)Items.f_151052_, "nugget", (ItemLike)TinkerMaterials.copperNugget, (TagKey)TinkerTags.Items.NUGGETS_COPPER, folder);
        this.packingRecipe(consumer, RecipeCategory.MISC, "ingot", (ItemLike)Items.f_42418_, "nugget", (ItemLike)TinkerMaterials.netheriteNugget, (TagKey)TinkerTags.Items.NUGGETS_NETHERITE, folder);
        Item cobaltIngot = TinkerMaterials.cobalt.getIngot();
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{TinkerWorld.rawCobalt, TinkerWorld.cobaltOre}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)cobaltIngot, (float)1.5f, (int)200).m_126132_("has_item", (CriterionTriggerInstance)CommonRecipeProvider.m_125977_(TinkerWorld.rawCobalt)).m_126140_(consumer, this.wrap(this.id((ItemLike)cobaltIngot), folder, "_smelting"));
        this.packingRecipe(consumer, RecipeCategory.MISC, "raw_block", (ItemLike)TinkerWorld.rawCobaltBlock, "raw", (ItemLike)TinkerWorld.rawCobalt, (TagKey)TinkerTags.Items.RAW_COBALT, folder);
    }
}

