/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.module.mining.MiningTierToolHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class TooltipBuilder {
    private static final TextColor MAX = TooltipBuilder.valueToColor(1.0f, 1.0f);
    private static final UnaryOperator<Style> APPLY_MAX = style -> style.m_131148_(MAX);
    private static final Component TOOLTIP_BROKEN = TConstruct.makeTranslation("tooltip", "tool.broken").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED});
    private static final Component TOOLTIP_BROKEN_PREFIXED = ToolStats.DURABILITY.getPrefix().m_7220_(TOOLTIP_BROKEN);
    private final IToolStackView tool;
    private final List<Component> tooltips;

    public TooltipBuilder(ToolStack tool) {
        this.tool = tool;
        this.tooltips = new ArrayList<Component>();
    }

    public TooltipBuilder add(Component textComponent) {
        this.tooltips.add(textComponent);
        return this;
    }

    private <T> Component formatValue(IToolStat<T> stat) {
        return stat.formatValue(this.tool.getStats().get(stat));
    }

    public TooltipBuilder add(IToolStat<?> stat) {
        this.tooltips.add(this.formatValue(stat));
        return this;
    }

    public TooltipBuilder addTier() {
        this.tooltips.add(ToolStats.HARVEST_TIER.formatValue(MiningTierToolHook.getTier(this.tool)));
        return this;
    }

    public TooltipBuilder addOptional(INumericToolStat<?> stat) {
        return this.addOptional(stat, 1.0f);
    }

    public TooltipBuilder addOptional(INumericToolStat<?> stat, float scale) {
        float value = ((Number)this.tool.getStats().get(stat)).floatValue();
        if (value > 0.0f) {
            this.tooltips.add(stat.formatValue(value * scale));
        }
        return this;
    }

    public static Component formatDurability(int durability, int ref, boolean textIfBroken) {
        if (textIfBroken && durability == 0) {
            return TOOLTIP_BROKEN_PREFIXED;
        }
        return ToolStats.DURABILITY.getPrefix().m_7220_(TooltipBuilder.formatPartialAmount(durability, ref));
    }

    public static TextColor valueToColor(float value, float max) {
        float hue = Mth.m_14036_((float)(value / max / 3.0f), (float)0.01f, (float)0.5f);
        return TextColor.m_131266_((int)Color.HSBtoRGB(hue, 0.65f, 0.8f));
    }

    public static Component formatPartialAmount(int value, int max) {
        return Component.m_237113_((String)Util.COMMA_FORMAT.format(value)).m_130938_(style -> style.m_131148_(TooltipBuilder.valueToColor(value, max))).m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)Util.COMMA_FORMAT.format(max)).m_130938_(APPLY_MAX));
    }

    public TooltipBuilder addDurability() {
        this.tooltips.add(TooltipBuilder.formatDurability(this.tool.getCurrentDurability(), this.tool.getStats().getInt(ToolStats.DURABILITY), false));
        return this;
    }

    public TooltipBuilder addWithAttribute(INumericToolStat<?> stat, Attribute attribute) {
        AttributeInstance instance;
        float damage = (float)attribute.m_22082_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (instance = player.m_21051_(attribute)) != null) {
            damage = (float)instance.m_22115_();
        }
        this.tooltips.add(stat.formatValue(damage + ((Number)this.tool.getStats().get(stat)).floatValue()));
        return this;
    }

    public TooltipBuilder addFreeSlots(SlotType slotType) {
        int slots = this.tool.getFreeSlots(slotType);
        if (slots > 0) {
            this.tooltips.add(IToolStat.formatNumber(slotType.getPrefix(), slotType.getColor(), slots));
        }
        return this;
    }

    public TooltipBuilder addAllFreeSlots() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            this.addFreeSlots(slotType);
        }
        return this;
    }

    public TooltipBuilder addModifierInfo(boolean advanced, @Nullable RegistryAccess access) {
        for (ModifierEntry entry : this.tool.getModifierList()) {
            if (!entry.getModifier().shouldDisplay(advanced)) continue;
            this.tooltips.add(entry.getModifier().getDisplayName(this.tool, entry, access));
        }
        return this;
    }

    public TooltipBuilder(IToolStackView tool, List<Component> tooltips) {
        this.tool = tool;
        this.tooltips = tooltips;
    }

    public List<Component> getTooltips() {
        return this.tooltips;
    }
}

