/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.util.ItemLayerPixels;
import slimeknights.tconstruct.library.client.modifiers.IBakedModifierModel;
import slimeknights.tconstruct.library.client.modifiers.IUnbakedModifierModel;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.slotless.TrimModifier;

public enum TrimModifierModel implements IBakedModifierModel
{
    INSTANCE;

    private static final Map<String, Material>[] TEXTURE_CACHE;
    public static final IUnbakedModifierModel UNBAKED_INSTANCE;

    @Override
    public Object getCacheKey(IToolStackView tool, ModifierEntry modifier) {
        return tool.getPersistentData().getString(TrimModifier.TRIM_MATERIAL);
    }

    @Override
    public void addQuads(IToolStackView tool, ModifierEntry modifier, Function<Material, TextureAtlasSprite> spriteGetter, Transformation transforms, boolean isLarge, int startTintIndex, Consumer<Collection<BakedQuad>> quadConsumer, @Nullable ItemLayerPixels pixels) {
        Item item;
        String materialId;
        if (!isLarge && !(materialId = tool.getPersistentData().getString(TrimModifier.TRIM_MATERIAL)).isEmpty() && (item = tool.getItem()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            Map<String, Material> cache = TEXTURE_CACHE[armor.m_266204_().ordinal()];
            Material texture = cache.get(materialId);
            if (texture == null) {
                TrimMaterial material;
                ResourceLocation path = new ResourceLocation("trims/items/" + armor.m_266204_().m_266355_() + "_trim");
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null && (material = (TrimMaterial)level.m_9598_().m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)materialId))) != null) {
                    path = path.m_266382_("_" + material.f_265854_());
                }
                texture = new Material(InventoryMenu.f_39692_, path);
                cache.put(materialId, texture);
            }
            quadConsumer.accept((Collection<BakedQuad>)MantleItemLayerModel.getQuadsForSprite((int)-1, (int)-1, (TextureAtlasSprite)spriteGetter.apply(texture), (Transformation)transforms, (int)0, (ItemLayerPixels)pixels));
        }
    }

    static {
        TEXTURE_CACHE = new Map[4];
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            TrimModifierModel.TEXTURE_CACHE[type.ordinal()] = new HashMap<String, Material>();
        }
        UNBAKED_INSTANCE = (smallGetter, largeGetter) -> {
            for (ArmorItem.Type type : ArmorItem.Type.values()) {
                TEXTURE_CACHE[type.ordinal()].clear();
            }
            return INSTANCE;
        };
    }
}

