/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.modifiers.slotless.TrimModifier;

public enum TrimArmorTextureSupplier implements ArmorTextureSupplier
{
    INSTANCE;

    private final SingletonLoader<TrimArmorTextureSupplier> LOADER = new SingletonLoader((Object)this);
    private static final Map<String, ArmorTextureSupplier.ArmorTexture> ARMOR_CACHE;
    private static final Map<String, ArmorTextureSupplier.ArmorTexture> LEGGING_CACHE;
    public static final ResourceManagerReloadListener CACHE_INVALIDATOR;

    @Override
    public ArmorTextureSupplier.ArmorTexture getArmorTexture(ItemStack stack, ArmorTextureSupplier.TextureType textureType, RegistryAccess access) {
        if (textureType != ArmorTextureSupplier.TextureType.WINGS) {
            String patternId = ModifierUtil.getPersistentString(stack, TrimModifier.TRIM_PATTERN);
            String materialId = ModifierUtil.getPersistentString(stack, TrimModifier.TRIM_MATERIAL);
            if (!patternId.isEmpty() && !materialId.isEmpty()) {
                String key;
                Map<String, ArmorTextureSupplier.ArmorTexture> cache = textureType == ArmorTextureSupplier.TextureType.LEGGINGS ? LEGGING_CACHE : ARMOR_CACHE;
                ArmorTextureSupplier.ArmorTexture texture = cache.get(key = patternId + "#" + materialId);
                if (texture != null) {
                    return texture;
                }
                TrimPattern pattern = (TrimPattern)access.m_175515_(Registries.f_266063_).m_7745_(ResourceLocation.m_135820_((String)patternId));
                TrimMaterial material = (TrimMaterial)access.m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)materialId));
                texture = ArmorTextureSupplier.ArmorTexture.EMPTY;
                if (pattern != null && material != null) {
                    ResourceLocation patternAsset = pattern.f_266052_();
                    texture = new TrimArmorTexture(patternAsset.m_247449_("trims/models/armor/" + patternAsset.m_135815_() + (textureType == ArmorTextureSupplier.TextureType.LEGGINGS ? "_leggings_" : "_") + material.f_265854_()));
                }
                cache.put(key, texture);
                return texture;
            }
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public SingletonLoader<TrimArmorTextureSupplier> getLoader() {
        return this.LOADER;
    }

    static {
        ARMOR_CACHE = new HashMap<String, ArmorTextureSupplier.ArmorTexture>();
        LEGGING_CACHE = new HashMap<String, ArmorTextureSupplier.ArmorTexture>();
        CACHE_INVALIDATOR = manager -> {
            ARMOR_CACHE.clear();
            LEGGING_CACHE.clear();
            TrimArmorTexture.armorTrimAtlas = null;
        };
    }

    public static class TrimArmorTexture
    implements ArmorTextureSupplier.ArmorTexture {
        private static TextureAtlas armorTrimAtlas = null;
        private final ResourceLocation trimLocation;
        private TextureAtlasSprite trimSprite = null;

        private static TextureAtlas getTrimAtlas() {
            if (armorTrimAtlas == null) {
                armorTrimAtlas = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_);
            }
            return armorTrimAtlas;
        }

        private TextureAtlasSprite getSprite() {
            if (this.trimSprite == null) {
                this.trimSprite = TrimArmorTexture.getTrimAtlas().m_118316_(this.trimLocation);
            }
            return this.trimSprite;
        }

        @Override
        public void renderTexture(Model model, PoseStack matrices, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean hasGlint) {
            VertexConsumer buffer = this.getSprite().m_118381_(bufferSource.m_6299_(Sheets.m_266442_()));
            model.m_7695_(matrices, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }

        public TrimArmorTexture(ResourceLocation trimLocation) {
            this.trimLocation = trimLocation;
        }
    }
}

