/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.MapColor;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;

public enum SlimeType implements StringRepresentable
{
    EARTH(118094, MapColor.f_283824_, false),
    SKY(117709, MapColor.f_283821_, false),
    ICHOR(16750349, MapColor.f_283750_, true, 10),
    ENDER(11488502, MapColor.f_283889_, false);

    public static final SlimeType[] TINKER;
    public static final SlimeType[] LIQUID;
    public static final SlimeType[] OVERWORLD;
    public static final SlimeType[] NETHER;
    private final int color;
    private final MapColor mapColor;
    private final boolean nether;
    private final int lightLevel;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final TagKey<Item> slimeballTag;
    private FoliageType foliageType;
    private DirtType dirtType;

    private SlimeType(int color, MapColor mapColor, boolean nether, int lightLevel) {
        this.color = color;
        this.mapColor = mapColor;
        this.nether = nether;
        this.lightLevel = lightLevel;
        this.slimeballTag = TinkerTags.Items.forgeTag("slimeball/" + this.m_7912_());
    }

    private SlimeType(int color, MapColor mapColor, boolean nether) {
        this(color, mapColor, nether, 0);
    }

    public FoliageType asFoliage() {
        if (this.foliageType == null) {
            this.foliageType = FoliageType.values()[this.ordinal()];
        }
        return this.foliageType;
    }

    public DirtType asDirt() {
        if (this.dirtType == null) {
            this.dirtType = DirtType.values()[this.ordinal()];
        }
        return this.dirtType;
    }

    public int getColor() {
        return this.color;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public boolean isNether() {
        return this.nether;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public TagKey<Item> getSlimeballTag() {
        return this.slimeballTag;
    }

    public FoliageType getFoliageType() {
        return this.foliageType;
    }

    public DirtType getDirtType() {
        return this.dirtType;
    }

    public String m_7912_() {
        return this.serializedName;
    }

    static {
        TINKER = new SlimeType[]{SKY, ICHOR, ENDER};
        LIQUID = new SlimeType[]{EARTH, SKY, ENDER};
        OVERWORLD = new SlimeType[]{EARTH, SKY, ENDER};
        NETHER = new SlimeType[]{ICHOR};
    }
}

